/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupGrouperMapper
extends TableMapper<Text, Put> {
    private static final boolean WRITE_TO_WAL = false;
    public static final String COUNTER_GROUP = "dedup.grouper";
    public static final String COUNTER_NAME = "written.rels";
    private Text rowKey;
    private DedupConfig dedupConf;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.rowKey = new Text();
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        byte[] family = DedupUtils.getSimilarityCFBytes(TypeProtos.Type.valueOf((String)this.dedupConf.getWf().getEntityType()));
        byte[] cellValue = Bytes.toBytes((String)"");
        List kvList = value.list();
        for (KeyValue n : kvList) {
            for (KeyValue j : kvList) {
                byte[] jq;
                byte[] nq = n.getQualifier();
                if (Arrays.equals(nq, jq = j.getQualifier())) continue;
                Put put = new Put(nq).add(family, jq, cellValue);
                put.setWriteToWAL(false);
                this.rowKey.set(nq);
                context.write((Object)this.rowKey, (Object)put);
                context.getCounter(COUNTER_GROUP, COUNTER_NAME).increment(1L);
            }
        }
    }
}

