package eu.dnetlib.data.objectstore.modular;

import javax.xml.ws.Endpoint;

import org.antlr.stringtemplate.StringTemplate;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.soap.EndpointReferenceBuilder;

// TODO: Auto-generated Javadoc
/**
 * The Class ObjectStoreProfileCreator is responsible of creating profile of the ObjectStore
 */
public class ObjectStoreProfileCreator {

	/**
	 * registry service locator.
	 */
	private ServiceLocator<ISRegistryService> registryLocator;

	/**
	 * mdstore ds template.
	 */
	private StringTemplate objectstoreDsTemplate;

	/**
	 * service endpoint.
	 */
	private Endpoint endpoint;

	/**
	 * endpoint builder.
	 */
	private EndpointReferenceBuilder<Endpoint> eprBuilder;

	/**
	 * Register profile.
	 *
	 * @param interpretation the interpretation
	 * @return the string
	 * @throws ISRegistryException the IS registry exception
	 */
	public String registerProfile(String interpretation)
			throws ISRegistryException {
		// XXX: mini hack
		StringTemplate template = new StringTemplate(
				objectstoreDsTemplate.getTemplate());
		template.setAttribute("serviceUri", eprBuilder.getAddress(endpoint));
		template.setAttribute("interpretation", interpretation);

		return registryLocator.getService()
				.registerProfile(template.toString());
	}

	/**
	 * Gets the registry locator.
	 *
	 * @return the registry locator
	 */
	public ServiceLocator<ISRegistryService> getRegistryLocator() {
		return registryLocator;
	}

	/**
	 * Sets the registry locator.
	 *
	 * @param registryLocator the new registry locator
	 */
	@Required
	public void setRegistryLocator(
			ServiceLocator<ISRegistryService> registryLocator) {
		this.registryLocator = registryLocator;
	}

	/**
	 * Gets the endpoint.
	 *
	 * @return the endpoint
	 */
	public Endpoint getEndpoint() {
		return endpoint;
	}

	/**
	 * Sets the endpoint.
	 *
	 * @param endpoint the new endpoint
	 */
	@Required
	public void setEndpoint(Endpoint endpoint) {
		this.endpoint = endpoint;
	}

	/**
	 * Gets the epr builder.
	 *
	 * @return the epr builder
	 */
	public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
		return eprBuilder;
	}

	/**
	 * Sets the epr builder.
	 *
	 * @param eprBuilder the new epr builder
	 */
	@Required
	public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
		this.eprBuilder = eprBuilder;
	}

	/**
	 * Gets the objectstore ds template.
	 *
	 * @return the objectstore ds template
	 */
	public StringTemplate getObjectstoreDsTemplate() {
		return objectstoreDsTemplate;
	}

	/**
	 * Sets the objectstore ds template.
	 *
	 * @param objectstoreDsTemplate the new objectstore ds template
	 */
	@Required
	public void setObjectstoreDsTemplate(StringTemplate objectstoreDsTemplate) {
		this.objectstoreDsTemplate = objectstoreDsTemplate;
	}

}
