/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.modular;

import eu.dnetlib.data.objectstore.modular.AbstractObjectStoreAction;
import eu.dnetlib.data.objectstore.modular.ModularObjectStoreFeeder;
import eu.dnetlib.data.objectstore.modular.ObjectStoreActions;
import eu.dnetlib.data.objectstore.modular.ObjectStoreProfileCreator;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import org.springframework.beans.factory.annotation.Required;

public class FeedObjectStoreAction
extends AbstractObjectStoreAction
implements BlackboardServerAction<ObjectStoreActions> {
    private ObjectStoreProfileCreator profileCreator;
    private ModularObjectStoreFeeder storeFeeder;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        String objStoreID = (String)job.getParameters().get("obsID");
        String objID = (String)job.getParameters().get("objID");
        String URI = (String)job.getParameters().get("URI");
        String eprRs = (String)job.getParameters().get("epr");
        String protocolString = (String)job.getParameters().get("protocol");
        Protocols protocol = protocolString == null ? Protocols.None : Protocols.valueOf((String)((String)job.getParameters().get("protocol")));
        String mime = (String)job.getParameters().get("mime");
        String login = (String)job.getParameters().get("login");
        String password = (String)job.getParameters().get("password");
        if (URI != null && URI.length() > 0) {
            this.storeFeeder.feedObject(objStoreID, objID, URI, protocol, login, password, mime);
        } else if (eprRs != null && eprRs.length() > 0) {
            this.storeFeeder.feed(objStoreID, eprRs, protocol, login, password, mime);
        }
        handler.done(job);
    }

    public ObjectStoreProfileCreator getProfileCreator() {
        return this.profileCreator;
    }

    @Required
    public void setProfileCreator(ObjectStoreProfileCreator profileCreator) {
        this.profileCreator = profileCreator;
    }

    public ModularObjectStoreFeeder getStoreFeeder() {
        return this.storeFeeder;
    }

    @Required
    public void setStoreFeeder(ModularObjectStoreFeeder storeFeeder) {
        this.storeFeeder = storeFeeder;
    }
}

