/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.modular;

import eu.dnetlib.data.objectstore.modular.connector.ObjectStoreDao;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.enabling.resultset.ResultSetFactory;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Required;

public class ModularObjectStoreDeliver {
    private ObjectStoreDao dao;
    @Resource
    private ResultSetFactory resultSetFactory;
    private ResultSetClientFactory resultSetClientFactory;

    public ObjectStoreDao getDao() {
        return this.dao;
    }

    @Required
    public void setDao(ObjectStoreDao dao) {
        this.dao = dao;
    }

    public W3CEndpointReference deliver(String objectStoreID, Double from, Double until) throws ObjectStoreServiceException {
        return this.resultSetFactory.createResultSet(this.dao.getObjectStore(objectStoreID).deliver(from, until));
    }

    public W3CEndpointReference deliverIds(String objectStoreID, W3CEndpointReference eprId) throws ObjectStoreServiceException {
        IterableResultSetClient ids = this.resultSetClientFactory.getClient(eprId);
        return this.resultSetFactory.createResultSet(this.dao.getObjectStore(objectStoreID).deliverIds((Iterable<String>)ids));
    }

    public boolean existIDStartsWith(String obsId, String startId) throws ObjectStoreServiceException {
        return this.dao.getObjectStore(obsId).existIDStartsWith(startId);
    }

    public ObjectStoreFile deliverObject(String objectStoreID, String objectId) throws ObjectStoreServiceException {
        return this.dao.getObjectStore(objectStoreID).deliverObject(objectId);
    }

    public InputStream deliverStream(String objectStoreID, String objectId) throws ObjectStoreServiceException {
        return this.dao.getObjectStore(objectStoreID).deliverStream(objectId);
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }
}

