/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.modular;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.objectstore.modular.ObjectBroker;
import eu.dnetlib.data.objectstore.modular.ObjectStoreRecord;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStoreDao;
import eu.dnetlib.data.objectstore.rmi.MetadataObjectRecord;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import org.springframework.beans.factory.annotation.Required;

public class ModularObjectStoreFeeder {
    private ObjectStoreDao dao;
    private ResultSetClientFactory resultSetClientFactory;
    private ServiceLocator<ISRegistryService> registryLocator;

    public ObjectStoreDao getDao() {
        return this.dao;
    }

    @Required
    public void setDao(ObjectStoreDao dao) {
        this.dao = dao;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public void feedMetadataObjectRecord(String objectStoreID, String rsEpr, final String mime) throws ObjectStoreServiceException {
        IterableResultSetClient records = this.resultSetClientFactory.getClient(rsEpr);
        Iterable toIngest = Iterables.transform((Iterable)records, (Function)new Function<String, MetadataObjectRecord>(){

            public MetadataObjectRecord apply(String input) {
                MetadataObjectRecord record = MetadataObjectRecord.initFromJson((String)input);
                record.setMime(mime);
                return record;
            }
        });
        ObjectStore store = this.dao.getObjectStore(objectStoreID);
        int size = store.feedMetadataRecord(toIngest, true);
        this.touch(objectStoreID, size);
    }

    public void feed(String obsId, String rsEpr, Protocols protocol, String login, String password, String mime) throws ObjectStoreServiceException {
        IterableResultSetClient records = this.resultSetClientFactory.getClient(rsEpr);
        ObjectBroker objectBroker = new ObjectBroker(protocol, login, password, mime);
        Iterable toIngest = Iterables.transform((Iterable)records, (Function)objectBroker);
        ObjectStore store = this.dao.getObjectStore(obsId);
        int size = store.feed(toIngest, true);
        this.touch(obsId, size);
    }

    public void feedObject(String objectStoreID, String objectID, String URIObject, Protocols protocol, String login, String password, String mime) throws ObjectStoreServiceException {
        ObjectStoreFile inputFile = new ObjectStoreFile();
        inputFile.setURI(URIObject);
        inputFile.setObjectID(objectID);
        ObjectBroker objectBroker = new ObjectBroker(protocol, login, password, mime);
        Iterable toIngest = Iterables.transform((Iterable)Lists.newArrayList((Object[])new String[]{inputFile.toJSON()}), (Function)objectBroker);
        ObjectStore store = this.dao.getObjectStore(objectStoreID);
        int size = store.feed(toIngest, true);
        this.touch(objectStoreID, size);
    }

    public String feedObjectRecord(String objectStoreID, ObjectStoreRecord record) throws ObjectStoreServiceException {
        ObjectStore store = this.dao.getObjectStore(objectStoreID);
        return store.feedObjectRecord(record);
    }

    public void touch(String obsId, int size) {
        try {
            String now = DateUtils.now_ISO8601();
            String mdstoreXUpdate = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + obsId + "']" + "return update value $x//LAST_STORAGE_DATE with '" + now + "'";
            ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(mdstoreXUpdate);
            this.touchSize(obsId, size);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void touchSize(String obsId, int size) {
        try {
            String mdstoreNumberXUpdate = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + obsId + "']" + "return update value $x//COUNT_STORE with '" + size + "'";
            ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(mdstoreNumberXUpdate);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }
}

