/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.modular.inspector;

import com.google.gson.Gson;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStoreDao;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ObjectStoreInspector
extends AbstractInspectorController {
    @Resource(name="gridFSObjectstoreDao")
    private ObjectStoreDao objectStoreDao;

    @RequestMapping(value={"/inspector/objectstores.do"})
    public void objectStores(Model model) {
        List<String> objectStores = this.objectStoreDao.listObjectStores();
        model.addAttribute("objectstores", (Object)MappedCollection.listMap(objectStores, (UnaryFunction)new UnaryFunction<ObjectStoreDescription, String>(){

            public ObjectStoreDescription evaluate(String id) {
                ObjectStore objStore = ObjectStoreInspector.this.objectStoreDao.getObjectStore(id);
                try {
                    return new ObjectStoreDescription(id, objStore.getSize());
                }
                catch (ObjectStoreServiceException e) {
                    return null;
                }
            }
        }));
    }

    @RequestMapping(value={"/inspector/objectstore.do"}, method={RequestMethod.GET})
    public void objectStore(Model model, @RequestParam(value="id") String id, @RequestParam(value="start", required=false) Integer startParam, @RequestParam(value="regex", required=false) String regex) throws ObjectStoreServiceException {
        int pageSize = 10;
        int start = 0;
        if (startParam != null) {
            start = startParam;
        }
        ObjectStore objctStore = this.objectStoreDao.getObjectStore(id);
        ResultSetListener rs = objctStore.deliver(0.0, Double.valueOf(System.currentTimeMillis()));
        List page = rs.getResult(1 + start, start + pageSize);
        final Gson g = new Gson();
        model.addAttribute("id", (Object)id);
        model.addAttribute("start", (Object)start);
        model.addAttribute("regex", (Object)regex);
        model.addAttribute("nextPage", (Object)(start + pageSize));
        model.addAttribute("prevPage", (Object)Math.max(0, start - pageSize));
        model.addAttribute("size", (Object)rs.getSize());
        model.addAttribute("page", (Object)MappedCollection.listMap((Iterable)page, (UnaryFunction)new UnaryFunction<ObjectStoreFile, String>(){

            public ObjectStoreFile evaluate(String json) {
                return (ObjectStoreFile)g.fromJson(json, ObjectStoreFile.class);
            }
        }));
    }

    public ObjectStoreDao getObjectStoreDao() {
        return this.objectStoreDao;
    }

    public void setObjectStoreDao(ObjectStoreDao objectStoreDao) {
        this.objectStoreDao = objectStoreDao;
    }

    class ObjectStoreDescription {
        private String id;
        private int size;

        public ObjectStoreDescription(String id, int size) {
            this.id = id;
            this.size = size;
        }

        public String getInterpretation() {
            ObjectStore objectStore = ObjectStoreInspector.this.objectStoreDao.getObjectStore(this.id);
            return objectStore.getInterpretation();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }
}

