$common/master(

header={
	$ui/repos/header()$
	<script type="text/javascript" src="../resources/js/dnet_param_values_functions.js"></script>
	<script type="text/javascript" src="../resources/js/addRepo.js"></script>
	<script type="text/javascript">
		function getTypes()     { return $types$ }
		function getCountries() { return $countries$ }
	</script>
	
	<style>
		.popover { max-width: 450px;  width: auto; }
	</style>
	
	
},
onLoad={},
body={
<div ng-app="addRepoUI" ng-controller="addRepoCtrl">
	<div ng-show="done" class="text-center">
		<h2>A new datasource has been registered !</h2> 
	</div>
	<div ng-hide="done">
		<form class="form-horizontal" role="form" name="newRepoForm">
		
			<fieldset>
				<legend>General Info</legend>
				<ng-simple-edit-field label="Datasource ID" selection="repo.id"></ng-simple-edit-field>
				<ng-simple-edit-field label="Official Name" selection="repo.officialName"></ng-simple-edit-field>
				<ng-simple-edit-field label="English Name" selection="repo.englishName" optional="true"></ng-simple-edit-field>
				<ng-simple-edit-field label="Organization" selection="repo.organization"></ng-simple-edit-field>
				<ng-select-vocabulary-field label="Typology Class" vocabulary="validTypes" selection="repo.datasourceClass"></ng-select-vocabulary-field>
			</fieldset>
			
			<fieldset>
				<legend>Contacts</legend>
				<ng-simple-edit-field label="WebSite Url" selection="repo.websiteUrl" regex="^(http|https):\/\/"></ng-simple-edit-field>
				<ng-simple-edit-field label="Contact Email" selection="repo.contactEmail" regex="^.+@.+"></ng-simple-edit-field>
			</fieldset>
				
			<fieldset>
				<legend>Geographical Info</legend>
				<ng-select-vocabulary-field label="Country" vocabulary="validCountries" selection="repo.countryCode"></ng-select-vocabulary-field>
				<ng-simple-edit-field label="Latitude" selection="repo.latitude" type="NUMBER"></ng-simple-edit-field>
				<ng-simple-edit-field label="Longitude" selection="repo.longitude" type="NUMBER"></ng-simple-edit-field>
			</fieldset>
			
			<fieldset>
				<legend>Technical Info</legend>
				<ng-simple-edit-field label="Namespace Prefix (12 chars)" selection="repo.namespacePrefix" regex="^\w{12}\$"></ng-simple-edit-field>
				<ng-simple-edit-field label="Software Typology" selection="repo.typology" optional="true"></ng-simple-edit-field>
				<ng-simple-edit-field label="Logo Url" selection="repo.logoUrl" regex="^(http|https):\/\/" optional="true"></ng-simple-edit-field>
			</fieldset>
			
			<br /><br />
			<div class="form-group">
				<div class="col-sm-offset-3 col-sm-9">
					<button class="btn btn-default" type="button" ng-click="resetForm()">reset</button>
					<button class="btn btn-primary" ng-disabled="newRepoForm.\$invalid" ng-click="registerRepo()">add</button>
				</div>
			</div>
		</form>
		<hr />
	</div>
	
	<!-- ENABLE TO DEBUG -->
	
	<!-- <p><b>Repo:</b> {{repo}}</p> -->
	
	
</div>
}

)$
