/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.cron;

import com.googlecode.sarasvati.GraphProcess;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.sarasvati.loader.WorkflowExecutor;
import eu.dnetlib.msro.workflows.sarasvati.registry.GraphProcessRegistry;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Required;

public class ScheduledWorkflowLauncher {
    private static final Log log = LogFactory.getLog(ScheduledWorkflowLauncher.class);
    private static final DateUtils dateUtils = new DateUtils();
    private WorkflowExecutor workflowExecutor;
    private GraphProcessRegistry graphProcessRegistry;
    private int windowSize = 0x6DDD00;
    @Resource
    private UniqueServiceLocator serviceLocator;

    public void verifySheduledWorkflows() {
        log.debug((Object)"Verifying scheduled workflows - START");
        String query = "for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where $x//CONFIGURATION/@status='EXECUTABLE' and $x//SCHEDULING/@enabled='true' return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x//SCHEDULING/CRON, ' @@@ ', $x//SCHEDULING/MININTERVAL)";
        try {
            for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where $x//CONFIGURATION/@status='EXECUTABLE' and $x//SCHEDULING/@enabled='true' return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x//SCHEDULING/CRON, ' @@@ ', $x//SCHEDULING/MININTERVAL)")) {
                String[] arr = s.split("@@@");
                String id = arr[0].trim();
                String cron = arr[1].trim();
                int minInterval = NumberUtils.toInt((String)arr[2].trim(), (int)0) * 60000;
                if (!CronExpression.isValidExpression((String)cron)) continue;
                Date now = new Date();
                Date last = this.calculateLastExecutionDate(id);
                int elapsed = Math.abs(Math.round(now.getTime() - last.getTime()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"**************************************************************");
                    log.debug((Object)("META WORKFLOW ID   : " + id));
                    log.debug((Object)("NOW                : " + now));
                    log.debug((Object)("LAST EXECUTION DATE: " + last));
                    log.debug((Object)("MIN INTERVAL       : " + minInterval));
                    log.debug((Object)("WINDOW SIZE        : " + this.windowSize));
                    log.debug((Object)("TIME ELAPSED       : " + elapsed));
                }
                if (elapsed > minInterval && this.isFired(cron, last, now) && !this.isAlreadyRunning(id)) {
                    log.debug((Object)"MUST BE EXECUTED   : true");
                    try {
                        this.workflowExecutor.startMetaWorkflow(id, false);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error launching scheduled wf: " + id), (Throwable)e);
                    }
                } else {
                    log.debug((Object)"MUST BE EXECUTED   : false");
                }
                log.debug((Object)"**************************************************************");
            }
        }
        catch (ISLookUpException e) {
            log.error((Object)"Error executing query for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where $x//CONFIGURATION/@status='EXECUTABLE' and $x//SCHEDULING/@enabled='true' return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x//SCHEDULING/CRON, ' @@@ ', $x//SCHEDULING/MININTERVAL)");
        }
        log.debug((Object)"Verifying scheduled workflows - END");
    }

    private boolean isFired(String cronExpression, Date startDate, Date now) {
        try {
            CronExpression cron = new CronExpression(cronExpression);
            Date prev = new Date(now.getTime() - (long)this.windowSize);
            Date date = prev.getTime() < startDate.getTime() ? startDate : prev;
            Date next = cron.getNextValidTimeAfter(date);
            if (log.isDebugEnabled()) {
                log.debug((Object)("NEXT EXECUTION DATE: " + next));
                log.debug((Object)("FIRED              : " + (next.getTime() < now.getTime())));
            }
            return next.getTime() < now.getTime();
        }
        catch (Exception e) {
            log.error((Object)("Error calculating next cron event: " + cronExpression), (Throwable)e);
            return false;
        }
    }

    private boolean isAlreadyRunning(String metaWfId) {
        String query = "doc('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType/" + StringUtils.substringBefore((String)metaWfId, (String)"_") + "')//WORKFLOW/@id/string()";
        try {
            for (String profileId : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query)) {
                if (profileId.length() <= 0) continue;
                for (GraphProcess p : this.graphProcessRegistry.findProcessesByResource(profileId)) {
                    switch (p.getState()) {
                        case Created: {
                            return true;
                        }
                        case Executing: {
                            return true;
                        }
                    }
                }
            }
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error executing query " + query));
        }
        return false;
    }

    private Date calculateLastExecutionDate(String id) {
        String query = "for $id in doc('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType/" + StringUtils.substringBefore((String)id, (String)"_") + "')//WORKFLOW/@id/string() " + "for $x in doc(concat('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType/', substring-before($id, '_'))) " + "where $x//LAST_EXECUTION_STATUS = 'SUCCESS' " + "return $x//LAST_EXECUTION_DATE/text() ";
        long time = 0L;
        try {
            for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query)) {
                Date d;
                if (s.length() <= 0 || time >= (d = dateUtils.parse(s)).getTime()) continue;
                time = d.getTime();
            }
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error executing query " + query));
        }
        catch (Exception e) {
            log.error((Object)"Error calculating date", (Throwable)e);
        }
        return new Date(time);
    }

    public WorkflowExecutor getWorkflowExecutor() {
        return this.workflowExecutor;
    }

    @Required
    public void setWorkflowExecutor(WorkflowExecutor workflowExecutor) {
        this.workflowExecutor = workflowExecutor;
    }

    public GraphProcessRegistry getGraphProcessRegistry() {
        return this.graphProcessRegistry;
    }

    @Required
    public void setGraphProcessRegistry(GraphProcessRegistry graphProcessRegistry) {
        this.graphProcessRegistry = graphProcessRegistry;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    @Required
    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }
}

