/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.download;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.download.rmi.DownloadService;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DownloadFromMetadataJobNode
extends BlackboardJobNode
implements ProgressJobNode {
    private String inputeprParam;
    private String objectStoreID;
    private String plugin;
    private String protocol;
    private String mimeType;
    @Autowired
    private ProcessCountingResultSetFactory processCountingResultSetFactory;
    private ResultsetProgressProvider progressProvider;

    @Override
    protected String obtainServiceId(NodeToken token) {
        return this.getServiceLocator().getServiceId(DownloadService.class);
    }

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        job.setAction("DOWNLOAD");
        String eprS = token.getEnv().getAttribute(this.getInputeprParam());
        this.progressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), eprS);
        job.getParameters().put("epr", this.progressProvider.getEpr().toString());
        job.getParameters().put("protocol", this.getProtocol());
        job.getParameters().put("plugin", this.getPlugin());
        job.getParameters().put("mimeType", this.getMimeType());
        job.getParameters().put("objectStoreID", this.getObjectStoreID());
    }

    @Override
    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){

            @Override
            protected void populateEnv(Env env, Map<String, String> responseParams) {
                env.setAttribute("mainlog:total", responseParams.get("total"));
            }
        };
    }

    public String getInputeprParam() {
        return this.inputeprParam;
    }

    public String getObjectStoreID() {
        return this.objectStoreID;
    }

    public void setObjectStoreID(String objectStoreID) {
        this.objectStoreID = objectStoreID;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protol) {
        this.protocol = protol;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setInputeprParam(String inputeprParam) {
        this.inputeprParam = inputeprParam;
    }

    @Override
    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }
}

