/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.mdstore;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.mdstore.MultipleMdStoreIterable;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Autowired;

public class FetchMultipleMDStores
extends SimpleJobNode {
    @Resource
    private UniqueServiceLocator serviceLocator;
    private List<String> mdId;
    private String mdFormat;
    private String eprParam;
    @Resource(name="iterableResultSetFactory")
    private IterableResultSetFactory resultSetFactory;
    @Autowired
    private ResultSetClientFactory resultSetClientFactory;

    @Override
    protected String execute(NodeToken token) throws Exception {
        if (this.getMdId() == null) {
            List mdIds = (List)new Gson().fromJson(token.getEnv().getAttribute("mdId"), List.class);
            this.setMdId(mdIds);
        }
        if (this.getMdFormat() == null) {
            this.setMdFormat(token.getEnv().getAttribute("mdFormat"));
        }
        MultipleMdStoreIterable iter = new MultipleMdStoreIterable(this.serviceLocator, this.getMdId(), this.resultSetClientFactory);
        W3CEndpointReference eprUrls = this.resultSetFactory.createIterableResultSet((Iterable)iter);
        token.getEnv().setAttribute(this.getEprParam(), eprUrls.toString());
        return Arc.DEFAULT_ARC;
    }

    public List<String> getMdId() {
        return this.mdId;
    }

    public void setMdId(List<String> mdId) {
        this.mdId = mdId;
    }

    public String getMdFormat() {
        return this.mdFormat;
    }

    public void setMdFormat(String mdFormat) {
        this.mdFormat = mdFormat;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }
}

