/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.mdstore;

import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MultipleMdStoreIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(MultipleMdStoreIterator.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    private List<String> mdIDs;
    private String currentId = null;
    private Iterator<String> currentIterator;
    @Autowired
    private ResultSetClientFactory resultSetClientFactory;

    public MultipleMdStoreIterator(UniqueServiceLocator serviceLocator, List<String> mdIds, ResultSetClientFactory resultSetClientFactory) {
        this.serviceLocator = serviceLocator;
        this.mdIDs = mdIds;
        this.resultSetClientFactory = resultSetClientFactory;
        this.getNextMDStoreRecords();
    }

    @Override
    public boolean hasNext() {
        if (this.currentId == null || this.currentIterator == null) {
            return false;
        }
        return this.currentIterator.hasNext();
    }

    @Override
    public String next() {
        String nextElement = this.currentIterator.next();
        if (!this.currentIterator.hasNext()) {
            this.getNextMDStoreRecords();
        }
        return nextElement;
    }

    @Override
    public void remove() {
        this.currentIterator.remove();
    }

    private void getNextMDStoreRecords() {
        if (this.mdIDs.size() > 0) {
            this.currentId = this.mdIDs.remove(0);
            this.currentIterator = this.getIterableResultset(this.currentId);
        }
    }

    private Iterator<String> getIterableResultset(String id) {
        try {
            W3CEndpointReference epr = ((MDStoreService)this.serviceLocator.getService(MDStoreService.class, id)).deliverMDRecords(id, "", "", "");
            IterableResultSetClient input = this.resultSetClientFactory.getClient(epr);
            return input.iterator();
        }
        catch (MDStoreServiceException e) {
            log.error((Object)e);
            return null;
        }
    }
}

