/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.transform;

import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.transform.GroovyUnaryFunction;
import groovy.lang.GroovyShell;
import groovy.util.GroovyScriptEngine;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class GroovyJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(GroovyJobNode.class);
    private MappedResultSetFactory mappedResultSetFactory;
    private String inputEprParam;
    private String outputEprParam;
    private String transformationRuleId;
    @Resource
    private UniqueServiceLocator serviceLocator;

    private Map<String, String> retrieveGroovyParameter() {
        HashMap out = Maps.newHashMap();
        String query = "for $x in collection('/db/DRIVER/GroovyProcessingDSResource/GroovyProcessingDSResourceType')where $x[.//RESOURCE_IDENTIFIER/@value='" + this.transformationRuleId + "']" + "return concat($x//GROOVY_CLASSPATH/text(),':::',$x//GROOVY_DNETCLASS/text())";
        try {
            String result = (String)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query).get(0);
            if (result == null) {
                return null;
            }
            String[] data = result.trim().split(":::");
            if (data.length == 2) {
                out.put("classpath", data[0]);
                out.put("mainClass", data[1]);
            }
            return out;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    @Override
    protected String execute(NodeToken token) throws Exception {
        String inputEprString = token.getEnv().getAttribute(this.inputEprParam);
        if (inputEprString == null || inputEprString.isEmpty()) {
            throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV");
        }
        W3CEndpointReference inputEpr = new EPRUtils().getEpr(inputEprString);
        Map<String, String> prop = this.retrieveGroovyParameter();
        String groovyClasspath = prop.get("classpath");
        String groovyDnetClass = prop.get("mainClass");
        W3CEndpointReference epr = this.transformGroovy(inputEpr, groovyClasspath, groovyDnetClass, this.parseJsonParameters(token));
        token.getEnv().setAttribute(this.outputEprParam, epr.toString());
        return Arc.DEFAULT_ARC;
    }

    private W3CEndpointReference transformGroovy(W3CEndpointReference source, String groovyClasspath, String groovyDnetClass, Map<String, String> params) throws ClassNotFoundException, IOException {
        GroovyScriptEngine gse = new GroovyScriptEngine(groovyClasspath);
        gse.getGroovyClassLoader().loadClass(groovyDnetClass);
        log.info((Object)"***********************************************");
        log.info((Object)"Loaded Groovy classes:");
        for (Class c : gse.getGroovyClassLoader().getLoadedClasses()) {
            log.info((Object)c.getCanonicalName());
        }
        log.info((Object)"***********************************************");
        GroovyShell groovyShell = new GroovyShell((ClassLoader)gse.getGroovyClassLoader());
        Object go = groovyShell.evaluate("new " + groovyDnetClass + "()");
        if (go instanceof GroovyUnaryFunction) {
            GroovyUnaryFunction groovyUnaryFunction = (GroovyUnaryFunction)go;
            if (params != null) {
                groovyUnaryFunction.setParams(params);
            }
            return this.mappedResultSetFactory.createMappedResultSet(source, (UnaryFunction)groovyUnaryFunction);
        }
        throw new RuntimeException("Groovy object " + go + " is not supported");
    }

    public MappedResultSetFactory getMappedResultSetFactory() {
        return this.mappedResultSetFactory;
    }

    @Required
    public void setMappedResultSetFactory(MappedResultSetFactory mappedResultSetFactory) {
        this.mappedResultSetFactory = mappedResultSetFactory;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getTransformationRuleId() {
        return this.transformationRuleId;
    }

    public void setTransformationRuleId(String transformationRuleId) {
        this.transformationRuleId = transformationRuleId;
    }
}

