/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.sarasvati.loader;

import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.load.DefaultNodeFactory;
import com.googlecode.sarasvati.load.SarasvatiLoadException;
import com.googlecode.sarasvati.mem.MemNode;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class InjectableNodeFactory
extends DefaultNodeFactory
implements ApplicationContextAware {
    private String beanNamePrefix = "wfNode";
    private static final String DEFAULT_NODE_TYPE = "node";
    private transient ApplicationContext applicationContext;

    public InjectableNodeFactory() {
        super(MemNode.class);
    }

    public InjectableNodeFactory(Class<? extends Node> defaultClass) {
        super(defaultClass);
    }

    public Node newNode(String type) throws SarasvatiLoadException {
        if (!DEFAULT_NODE_TYPE.equals(type)) {
            Node prototypeNode = (Node)this.applicationContext.getBean(this.beanNamePrefix + type, Node.class);
            if (prototypeNode != null) {
                return prototypeNode;
            }
            throw new SarasvatiLoadException("cannot find bean " + this.beanNamePrefix + type);
        }
        return super.newNode(type);
    }

    public void setApplicationContext(ApplicationContext context) {
        this.applicationContext = context;
    }

    public String getBeanNamePrefix() {
        return this.beanNamePrefix;
    }

    @Required
    public void setBeanNamePrefix(String beanNamePrefix) {
        this.beanNamePrefix = beanNamePrefix;
    }
}

