/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.download;

import com.google.common.base.Function;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.DownloadItem;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class UrlExtractor
implements Function<String, String> {
    private static final Log log = LogFactory.getLog(UrlExtractor.class);
    private String xpathURL;
    private String xpathMetadataID;
    private String xpathOpenAccess;
    private String xpathEmbargoDate;

    public UrlExtractor(String xpath, String xpathMetadataID, String xpathOpenAccess, String xpathEmbargoDate) {
        this.xpathURL = xpath;
        this.xpathMetadataID = xpathMetadataID;
        this.xpathOpenAccess = xpathOpenAccess;
        this.xpathEmbargoDate = xpathEmbargoDate;
    }

    public String apply(String input) {
        try {
            String embargoDate;
            DownloadItem di = new DownloadItem();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (input == null) {
                log.error((Object)"Metadata input is null");
                return null;
            }
            Document doc = builder.parse(new ByteArrayInputStream(input.getBytes()));
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath myXpath = xPathFactory.newXPath();
            XPathExpression expression = myXpath.compile(this.xpathURL);
            Object values = expression.evaluate(doc, XPathConstants.NODESET);
            di.setUrl(this.getNodes((NodeList)values));
            di.setOriginalUrl(this.getNodes((NodeList)values));
            if (this.xpathOpenAccess != null) {
                expression = myXpath.compile(this.xpathOpenAccess);
                String openAccess = expression.evaluate(doc);
                di.setOpenAccess(openAccess);
            }
            if (this.xpathEmbargoDate != null && !StringUtils.isEmpty((String)(embargoDate = (expression = myXpath.compile(this.xpathEmbargoDate)).evaluate(doc)))) {
                try {
                    DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
                    DateTime dt = fmt.parseDateTime(embargoDate);
                    di.setEmbargoDate(dt.toDate());
                }
                catch (Exception pe) {
                    // empty catch block
                }
            }
            expression = myXpath.compile(this.xpathMetadataID);
            String extracted_metadataId = expression.evaluate(doc);
            di.setIdItemMetadata(extracted_metadataId);
            return di.toJSON();
        }
        catch (Exception e) {
            log.error((Object)"OPSSS... Something bad happen on evaluating ", (Throwable)e);
            return null;
        }
    }

    private String getNodes(NodeList nodes) {
        ArrayList<String> extracted_Url = new ArrayList<String>();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                extracted_Url.add(nodes.item(i).getNodeValue());
            }
        }
        return new Gson().toJson(extracted_Url);
    }

    public String getXpathMetadataID() {
        return this.xpathMetadataID;
    }

    public void setXpathMetadataID(String xpathMetadataID) {
        this.xpathMetadataID = xpathMetadataID;
    }

    public String getXpathURL() {
        return this.xpathURL;
    }

    public void setXpathURL(String xpathURL) {
        this.xpathURL = xpathURL;
    }

    public String getXpathOpenAccess() {
        return this.xpathOpenAccess;
    }

    public void setXpathOpenAccess(String xpathOpenAccess) {
        this.xpathOpenAccess = xpathOpenAccess;
    }

    public String getXpathEmbargoDate() {
        return this.xpathEmbargoDate;
    }

    public void setXpathEmbargoDate(String xpathEmbargoDate) {
        this.xpathEmbargoDate = xpathEmbargoDate;
    }
}

