package eu.dnetlib.data.oai.store.actions;

import java.util.concurrent.Callable;

import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.data.oai.store.conf.OAISetsCounter;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class CountSetsAction extends AbstractOAIStoreAction {

	@Autowired
	private OAISetsCounter setsCounter;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		String configuredOnly = job.getParameters().get("configuredOnly");
		String storeId = job.getParameters().get("collection");
		String dbName = job.getParameters().get("oai_dbName");

		if (configuredOnly.equalsIgnoreCase("false")) {
			this.executeForAll(storeId, handler, job, dbName);
		} else {
			this.executeForConfiguredSetsOnly(storeId, handler, job, dbName);
		}

	}

	private void executeForAll(final String storeId, final BlackboardServerHandler handler, final BlackboardJob job, final String dbName) {

		this.setsCounter.updateCounts(storeId, dbName, new Callable<Object>() {

			@Override
			public Object call() {
				handler.done(job);
				return null;
			}
		}, new Callable<Object>() {

			@Override
			public Object call() {
				handler.failed(job, new Exception("Error during OAI sets count on db " + dbName));
				return null;
			}
		});
	}

	private void executeForConfiguredSetsOnly(final String storeId, final BlackboardServerHandler handler, final BlackboardJob job, final String dbName) {
		this.setsCounter.updateConfigurationCounts(storeId, dbName, new Callable<Object>() {

			@Override
			public Object call() {
				handler.done(job);
				return null;
			}
		}, new Callable<Object>() {

			@Override
			public Object call() {
				handler.failed(job, new Exception("Error during OAI sets count on db " + dbName));
				return null;
			}
		});
	}

	public OAISetsCounter getSetsCounter() {
		return setsCounter;
	}

	public void setSetsCounter(final OAISetsCounter setsCounter) {
		this.setsCounter = setsCounter;
	}
}
