package eu.dnetlib.data.oai.store.actions;

import java.util.Arrays;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class CreateOAIIndexAction extends AbstractOAIStoreAction {

	@Resource
	private MongoPublisherStoreDAO mongoPublisherStoreDAO;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		String storeId = job.getParameters().get("collection");
		String dbName = job.getParameters().get("oai_dbName");
		// Examples: field1,field2 -- one compound index on the given two fields
		// field1,field2;field3,field4 -- two compound indices: one on field1 and field2, the other on field3 and field4
		String fieldNames = job.getParameters().get("oai_index_fieldNames");
		if (StringUtils.isBlank(storeId) || StringUtils.isBlank(fieldNames)) throw new IllegalArgumentException(
				"Job parameters collection and oai_index_fieldNames are mandatory");
		else {
			MongoPublisherStore store = this.mongoPublisherStoreDAO.getStore(storeId, dbName);
			if (store != null) {
				String[] indexFieldList = fieldNames.replaceAll(" ", "").split(";");
				for (String idx : indexFieldList) {
					String[] fields = idx.split(",");
					store.createCompoundIndex(Arrays.asList(fields));
				}
				handler.done(job);
			} else throw new OaiPublisherRuntimeException("store " + storeId + " does not exist on db " + dbName + ": can't create compound indices");
		}
	}

	public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
		return mongoPublisherStoreDAO;
	}

	public void setMongoPublisherStoreDAO(final MongoPublisherStoreDAO mongoPublisherStoreDAO) {
		this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
	}

}
