package eu.dnetlib.data.oai.store.actions;

import javax.annotation.Resource;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateStoreAction extends AbstractOAIStoreAction {

	private static final Log log = LogFactory.getLog(CreateStoreAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private MongoPublisherStoreDAO mongoPublisherStoreDAO;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		String mdformat = job.getParameters().get("format");
		String layout = job.getParameters().get("layout");
		String interp = job.getParameters().get("interpretation");
		String dbName = job.getParameters().get("oai_dbName");
		if (this.mongoPublisherStoreDAO.getStore(mdformat, interp, layout, dbName) == null) {
			MongoPublisherStore store = this.mongoPublisherStoreDAO.createStore(mdformat, interp, layout, dbName);
			if(store == null){
				log.error("Could not create MongoPublisherStore");
				handler.failed(job, new OaiPublisherException(String.format("Cannot create OAI store for %s, %s, %s on db %s", mdformat, interp, layout, dbName)));
			}
			log.info("Created store with id: " + store.getId() + "on db " + dbName+": \n"+store.toString());
		} else {
			log.info("Store already exists for format=" + mdformat + " layout=" + layout + " interpretation=" + interp + " on db " + dbName);
		}
		handler.done(job);
	}

}
