package eu.dnetlib.data.oai.store.actions;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class DropStoreAction extends AbstractOAIStoreAction {

	private static final Log log = LogFactory.getLog(DropStoreAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private MongoPublisherStoreDAO mongoPublisherStoreDAO;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		String mdformat = job.getParameters().get("format");
		String layout = job.getParameters().get("layout");
		String interp = job.getParameters().get("interpretation");
		String dbName = job.getParameters().get("oai_dbName");
		String set = job.getParameters().get("set");
		boolean deleted = false;
		if (StringUtils.isNotBlank(set)) {
			deleted = mongoPublisherStoreDAO.deleteFromStore(mdformat, interp, layout, dbName, set);
		} else {
			deleted = this.mongoPublisherStoreDAO.deleteStore(mdformat, interp, layout, dbName);
		}
		if (deleted) {
			log.info("OAI Deletion succeded on db " + dbName);
		} else {
			log.info("Probably the store to delete does not exist. OAI Deletion failed on db " + dbName);
		}
		handler.done(job);
	}
}
