/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store;

import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.OAIStoreService;
import eu.dnetlib.data.oai.store.conf.OAISetHelper;
import eu.dnetlib.data.oai.store.conf.OAISetsCounter;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.data.oai.store.sync.OAIStoreSynchronizer;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class OAIStoreServiceImpl
extends AbstractBaseService
implements OAIStoreService {
    private NotificationHandler notificationHandler;
    @Autowired
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;
    @Resource
    private OAIStoreSynchronizer synchronizer;
    @Resource(name="oaiSetsCounter")
    private OAISetsCounter setsCounter;
    @Autowired
    private OAISetHelper oaiSetHelper;
    @Resource
    private ResultSetClientFactory resultSetClientFactory;

    public void feed(W3CEndpointReference recordsEpr, MDFInfo mdfInfo, String dbName) {
        this.feed(recordsEpr, mdfInfo, "", dbName);
    }

    public void feed(W3CEndpointReference recordsEpr, MDFInfo mdfInfo, String recordSource, String dbName) {
        IterableResultSetClient rsClient = this.resultSetClientFactory.getClient(recordsEpr);
        this.synchronizer.synchronize((Iterable<String>)rsClient, mdfInfo, recordSource, dbName, false, null, null);
    }

    public void updateSetCounts(String dbName) {
        this.setsCounter.updateCounts("", dbName, null, null);
    }

    public void updateSetCounts(MDFInfo mdfInfo, String dbName) {
        this.setsCounter.updateCounts(mdfInfo, dbName, null, null);
    }

    public void refreshConfiguration(String dbName) {
        this.oaiSetHelper.loadConfiguration(dbName);
    }

    public void ensureIndexes(String dbName) {
        this.mongoPublisherStoreDAO.ensureIndex(dbName);
    }

    public void ensureIndexes(MDFInfo mdfInfo, String dbName) {
        MongoPublisherStore s = this.mongoPublisherStoreDAO.getStore(mdfInfo.getSourceFormatName(), mdfInfo.getSourceFormatInterpretation(), mdfInfo.getSourceFormatLayout(), dbName);
        s.ensureIndices();
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        this.getNotificationHandler().notified(subscriptionId, topic, isId, message);
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Required
    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public OAIStoreSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public void setSynchronizer(OAIStoreSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public OAISetsCounter getSetsCounter() {
        return this.setsCounter;
    }

    public void setSetsCounter(OAISetsCounter setsCounter) {
        this.setsCounter = setsCounter;
    }

    public OAISetHelper getOaiSetHelper() {
        return this.oaiSetHelper;
    }

    public void setOaiSetHelper(OAISetHelper oaiSetHelper) {
        this.oaiSetHelper = oaiSetHelper;
    }

    public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
        return this.mongoPublisherStoreDAO;
    }

    public void setMongoPublisherStoreDAO(MongoPublisherStoreDAO mongoPublisherStoreDAO) {
        this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }
}

