/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.actions;

import eu.dnetlib.data.oai.store.actions.AbstractOAIStoreAction;
import eu.dnetlib.data.oai.store.conf.OAISetsCounter;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.annotation.Autowired;

public class CountSetsAction
extends AbstractOAIStoreAction {
    @Autowired
    private OAISetsCounter setsCounter;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        String configuredOnly = (String)job.getParameters().get("configuredOnly");
        String storeId = (String)job.getParameters().get("collection");
        String dbName = (String)job.getParameters().get("oai_dbName");
        if (configuredOnly.equalsIgnoreCase("false")) {
            this.executeForAll(storeId, handler, job, dbName);
        } else {
            this.executeForConfiguredSetsOnly(storeId, handler, job, dbName);
        }
    }

    private void executeForAll(String storeId, final BlackboardServerHandler handler, final BlackboardJob job, final String dbName) {
        this.setsCounter.updateCounts(storeId, dbName, new Callable<Object>(){

            @Override
            public Object call() {
                handler.done(job);
                return null;
            }
        }, new Callable<Object>(){

            @Override
            public Object call() {
                handler.failed(job, (Throwable)new Exception("Error during OAI sets count on db " + dbName));
                return null;
            }
        });
    }

    private void executeForConfiguredSetsOnly(String storeId, final BlackboardServerHandler handler, final BlackboardJob job, final String dbName) {
        this.setsCounter.updateConfigurationCounts(storeId, dbName, new Callable<Object>(){

            @Override
            public Object call() {
                handler.done(job);
                return null;
            }
        }, new Callable<Object>(){

            @Override
            public Object call() {
                handler.failed(job, (Throwable)new Exception("Error during OAI sets count on db " + dbName));
                return null;
            }
        });
    }

    public OAISetsCounter getSetsCounter() {
        return this.setsCounter;
    }

    public void setSetsCounter(OAISetsCounter setsCounter) {
        this.setsCounter = setsCounter;
    }
}

