/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.actions;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.oai.store.actions.AbstractOAIStoreAction;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.util.Arrays;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

public class CreateOAIIndexAction
extends AbstractOAIStoreAction {
    @Resource
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        String storeId = (String)job.getParameters().get("collection");
        String dbName = (String)job.getParameters().get("oai_dbName");
        String fieldNames = (String)job.getParameters().get("oai_index_fieldNames");
        if (StringUtils.isBlank((String)storeId) || StringUtils.isBlank((String)fieldNames)) {
            throw new IllegalArgumentException("Job parameters collection and oai_index_fieldNames are mandatory");
        }
        MongoPublisherStore store = this.mongoPublisherStoreDAO.getStore(storeId, dbName);
        if (store != null) {
            String[] indexFieldList;
            for (String idx : indexFieldList = fieldNames.replaceAll(" ", "").split(";")) {
                String[] fields = idx.split(",");
                store.createCompoundIndex(Arrays.asList(fields));
            }
        } else {
            throw new OaiPublisherRuntimeException("store " + storeId + " does not exist on db " + dbName + ": can't create compound indices");
        }
        handler.done(job);
    }

    public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
        return this.mongoPublisherStoreDAO;
    }

    public void setMongoPublisherStoreDAO(MongoPublisherStoreDAO mongoPublisherStoreDAO) {
        this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
    }
}

