/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.actions;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.oai.store.actions.AbstractOAIStoreAction;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateStoreAction
extends AbstractOAIStoreAction {
    private static final Log log = LogFactory.getLog(CreateStoreAction.class);
    @Resource
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        String dbName;
        String mdformat = (String)job.getParameters().get("format");
        String layout = (String)job.getParameters().get("layout");
        String interp = (String)job.getParameters().get("interpretation");
        if (this.mongoPublisherStoreDAO.getStore(mdformat, interp, layout, dbName = (String)job.getParameters().get("oai_dbName")) == null) {
            MongoPublisherStore store = this.mongoPublisherStoreDAO.createStore(mdformat, interp, layout, dbName);
            if (store == null) {
                log.error((Object)"Could not create MongoPublisherStore");
                handler.failed(job, (Throwable)new OaiPublisherException(String.format("Cannot create OAI store for %s, %s, %s on db %s", mdformat, interp, layout, dbName)));
            }
            log.info((Object)("Created store with id: " + store.getId() + "on db " + dbName + ": \n" + store.toString()));
        } else {
            log.info((Object)("Store already exists for format=" + mdformat + " layout=" + layout + " interpretation=" + interp + " on db " + dbName));
        }
        handler.done(job);
    }
}

