/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.actions;

import eu.dnetlib.data.oai.store.actions.AbstractOAIStoreAction;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DropStoreAction
extends AbstractOAIStoreAction {
    private static final Log log = LogFactory.getLog(DropStoreAction.class);
    @Resource
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        String mdformat = (String)job.getParameters().get("format");
        String layout = (String)job.getParameters().get("layout");
        String interp = (String)job.getParameters().get("interpretation");
        String dbName = (String)job.getParameters().get("oai_dbName");
        String set = (String)job.getParameters().get("set");
        boolean deleted = false;
        deleted = StringUtils.isNotBlank((String)set) ? this.mongoPublisherStoreDAO.deleteFromStore(mdformat, interp, layout, dbName, set) : this.mongoPublisherStoreDAO.deleteStore(mdformat, interp, layout, dbName);
        if (deleted) {
            log.info((Object)("OAI Deletion succeded on db " + dbName));
        } else {
            log.info((Object)("Probably the store to delete does not exist. OAI Deletion failed on db " + dbName));
        }
        handler.done(job);
    }
}

