/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.actions;

import eu.dnetlib.data.oai.store.actions.AbstractOAIStoreAction;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnsureIndexesAction
extends AbstractOAIStoreAction {
    private static final Log log = LogFactory.getLog(EnsureIndexesAction.class);
    @Resource
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        try {
            String storeId = (String)job.getParameters().get("collection");
            String dbName = (String)job.getParameters().get("oai_dbName");
            if (StringUtils.isBlank((String)storeId)) {
                log.info((Object)"Ensuring index on all OAI store");
                this.mongoPublisherStoreDAO.ensureIndex(dbName);
            } else {
                log.info((Object)("Ensuring index on " + storeId + " only"));
                MongoPublisherStore store = this.mongoPublisherStoreDAO.getStore(storeId, dbName);
                store.ensureIndices();
            }
            handler.done(job);
        }
        catch (Exception e) {
            handler.failed(job, (Throwable)e);
        }
    }

    public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
        return this.mongoPublisherStoreDAO;
    }

    public void setMongoPublisherStoreDAO(MongoPublisherStoreDAO mongoPublisherStoreDAO) {
        this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
    }
}

