/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.actions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.actions.AbstractOAIStoreAction;
import eu.dnetlib.data.oai.store.sync.OAIStoreSynchronizer;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.ClassPathResource;

public class SyncAction
extends AbstractOAIStoreAction {
    private static final Log log = LogFactory.getLog(SyncAction.class);
    @Resource
    private OAIStoreSynchronizer synchronizer;
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    org.springframework.core.io.Resource dmfXsltResource = new ClassPathResource("/eu/dnetlib/data/oai/store/xslt/addDMFBlock.xslt");
    private final SAXReader saxReader = new SAXReader();

    public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
        EPRUtils eprUtils = new EPRUtils();
        W3CEndpointReference epr = eprUtils.getEpr((String)job.getParameters().get("oai_syncEpr"));
        String recordSource = (String)job.getParameters().get("oai_recordSource");
        String formatName = (String)job.getParameters().get("oai_formatName");
        String formatLayout = (String)job.getParameters().get("oai_formatLayout");
        String formatInterpretation = (String)job.getParameters().get("oai_formatInterpretation");
        boolean alwaysNewRecord = Boolean.valueOf((String)job.getParameters().get("oai_alwaysNewRecord"));
        final String dbName = (String)job.getParameters().get("oai_dbName");
        MDFInfo mdf = new MDFInfo("", "", "", formatName, formatLayout, formatInterpretation, "", true);
        IterableResultSetClient client = this.resultSetClientFactory.getClient(epr);
        log.info((Object)("Syncronizing content for oai on db " + dbName + "for metadata format: " + mdf));
        Object records = client;
        if (formatName.equalsIgnoreCase("DMF")) {
            records = this.addDMFBlock((Iterable<String>)client);
        }
        this.synchronizer.synchronize((Iterable<String>)records, mdf, recordSource, dbName, alwaysNewRecord, new Callable<Object>(){

            @Override
            public Object call() {
                handler.done(job);
                return null;
            }
        }, new Callable<Object>(){

            @Override
            public Object call() {
                handler.failed(job, (Throwable)new Exception("Error during OAI synchronization on db " + dbName));
                return null;
            }
        });
    }

    protected Iterable<String> addDMFBlock(Iterable<String> input) {
        final ApplyXslt addDMFBlockXslt = new ApplyXslt(this.dmfXsltResource);
        return Iterables.transform(input, (Function)new Function<String, String>(){

            public String apply(String dmfRecord) {
                return addDMFBlockXslt.evaluate((Object)dmfRecord);
            }
        });
    }

    public OAIStoreSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public void setSynchronizer(OAIStoreSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public ResultSetClientFactory getRsClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setRsClientFactory(ResultSetClientFactory rsClientFactory) {
        this.resultSetClientFactory = rsClientFactory;
    }
}

