/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.conf;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.data.oai.store.sets.MongoSetCollection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAISetHelper {
    private static final Log log = LogFactory.getLog(OAISetHelper.class);
    @Resource(name="oaiConfigurationExistReader")
    private OAIConfigurationReader configurationReader;
    @Resource
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;
    @Resource
    private MongoSetCollection mongoSetCollection;

    public void loadConfiguration(String dbName) {
        this.loadConfigurationSets(dbName);
    }

    private void loadConfigurationSets(String dbName) {
        log.debug((Object)"*****Dropping and re-creating configuration sets******");
        this.mongoSetCollection.dropConfigurationSets(dbName);
        List oaiConfigSets = this.configurationReader.getSets();
        for (SetInfo setInfo : oaiConfigSets) {
            this.mongoSetCollection.upsertSet(setInfo, true, dbName);
        }
        log.info((Object)("Configuration Sets updated succesfully on db: " + dbName));
    }

    public void updateAllCounts(MDFInfo mdFormat, String dbName) {
        this.mongoSetCollection.ensureIndexes(dbName);
        MongoPublisherStore store = this.getStore(mdFormat, dbName);
        if (store == null) {
            throw new OaiPublisherRuntimeException("Can't count elements for not yet created store (" + mdFormat + ") on db " + dbName);
        }
        this.updateTotalCount(store, mdFormat, dbName);
        this.updateProvenanceSetsCount(store, mdFormat, dbName);
        this.updateConfiguredSetsCount(store, mdFormat, dbName);
    }

    public void updateConfiguredSetsCount(MDFInfo mdFormat, String dbName) {
        this.mongoSetCollection.ensureIndexes(dbName);
        MongoPublisherStore store = this.getStore(mdFormat, dbName);
        if (store == null) {
            throw new OaiPublisherRuntimeException("Can't count elements for not yet created store (" + mdFormat + ") on db " + dbName);
        }
        this.updateConfiguredSetsCount(store, mdFormat, dbName);
    }

    protected void updateConfiguredSetsCount(MongoPublisherStore store, MDFInfo mdFormat, String dbName) {
        List<SetInfo> sets = this.mongoSetCollection.getConfiguredSets(dbName);
        this.updateCountForSets(store, sets, mdFormat, dbName);
    }

    protected void updateProvenanceSetsCount(MongoPublisherStore store, MDFInfo mdFormat, String dbName) {
        List<String> distinctSetSpecs = store.getDistinctSetNamesFromRecords();
        store.upsertSets(distinctSetSpecs);
        List<SetInfo> sets = this.mongoSetCollection.getSetsFromData(dbName);
        this.updateCountForSets(store, sets, mdFormat, dbName);
    }

    protected void updateTotalCount(MongoPublisherStore store, MDFInfo mdFormat, String dbName) {
        String baseQuery = mdFormat.getBaseQuery();
        int total = store.count(baseQuery);
        this.mongoSetCollection.updateCounts("ALL", mdFormat.getPrefix(), total, dbName);
        log.info((Object)("Got total for " + mdFormat.getPrefix() + " with query: " + baseQuery + " on db " + dbName));
    }

    protected void updateCountForSets(MongoPublisherStore store, List<SetInfo> oaiSets, MDFInfo mdFormat, String dbName) {
        String baseQuery = mdFormat.getBaseQuery();
        boolean hasBaseQuery = !StringUtils.isBlank((String)baseQuery);
        for (SetInfo setInfo : oaiSets) {
            String setQuery = "(" + setInfo.getQuery() + ")";
            if (hasBaseQuery) {
                setQuery = setQuery + " AND (" + baseQuery + ")";
            }
            log.info((Object)("Counting total for " + mdFormat.getPrefix() + " set " + setInfo + " with query: " + setQuery + " on db " + dbName));
            int setCount = store.count(setQuery);
            this.mongoSetCollection.updateCounts(setInfo.getSetSpec(), mdFormat.getPrefix(), setCount, dbName);
        }
    }

    private MongoPublisherStore getStore(MDFInfo mdFormat, String dbName) {
        String format = mdFormat.getSourceFormatName();
        String layout = mdFormat.getSourceFormatLayout();
        String interpretation = mdFormat.getSourceFormatInterpretation();
        String sourceKey = format + "-" + layout + "-" + interpretation;
        MongoPublisherStore store = this.mongoPublisherStoreDAO.getStore(format, interpretation, layout, dbName);
        log.info((Object)("Got OAI store " + sourceKey + " via metadata prefix " + mdFormat.getPrefix() + " on db " + dbName));
        return store;
    }

    public OAIConfigurationReader getConfigurationReader() {
        return this.configurationReader;
    }

    public void setConfigurationReader(OAIConfigurationReader configurationReader) {
        this.configurationReader = configurationReader;
    }

    public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
        return this.mongoPublisherStoreDAO;
    }

    public void setMongoPublisherStoreDAO(MongoPublisherStoreDAO mongoPublisherStoreDAO) {
        this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
    }

    public MongoSetCollection getMongoSetCollection() {
        return this.mongoSetCollection;
    }

    public void setMongoSetCollection(MongoSetCollection mongoSetCollection) {
        this.mongoSetCollection = mongoSetCollection;
    }
}

