/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.mongo;

import com.google.common.collect.Lists;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCursor;
import eu.dnetlib.data.information.oai.publisher.info.RecordInfo;
import eu.dnetlib.data.oai.store.Cursor;
import eu.dnetlib.data.oai.store.mongo.MetadataExtractor;
import eu.dnetlib.data.oai.store.mongo.ProvenanceExtractor;
import eu.dnetlib.data.oai.store.mongo.RecordInfoGenerator;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.Iterator;

public class DNetOAIMongoCursor
implements Cursor {
    private MongoCursor<DBObject> dbCursor;
    private int size = 0;
    private UnaryFunction<String, String> function;
    private boolean bodyIncluded;
    private RecordInfoGenerator recordInfoGenerator;
    private MetadataExtractor metadataExtractor;
    private ProvenanceExtractor provenanceExtractor;

    public DNetOAIMongoCursor() {
    }

    public DNetOAIMongoCursor(MongoCursor<DBObject> dbCursor, boolean bodyIncluded, RecordInfoGenerator recordInfoGenerator, MetadataExtractor metadataExtractor) {
        this(dbCursor, null, bodyIncluded, recordInfoGenerator, metadataExtractor);
    }

    public DNetOAIMongoCursor(MongoCursor<DBObject> dbCursor, UnaryFunction<String, String> function, boolean bodyIncluded, RecordInfoGenerator recordInfoGenerator, MetadataExtractor metadataExtractor) {
        this.dbCursor = dbCursor;
        this.size = 0;
        this.function = function;
        this.bodyIncluded = bodyIncluded;
        this.recordInfoGenerator = recordInfoGenerator;
        this.metadataExtractor = metadataExtractor;
    }

    @Override
    public int count() {
        if (this.size == 0) {
            this.size = Lists.newArrayList(this.dbCursor).size();
        }
        return this.size;
    }

    @Override
    public Iterator<RecordInfo> iterator() {
        return new Iterator<RecordInfo>(){

            @Override
            public boolean hasNext() {
                return DNetOAIMongoCursor.this.dbCursor.hasNext();
            }

            @Override
            public RecordInfo next() {
                DBObject res = (DBObject)DNetOAIMongoCursor.this.dbCursor.next();
                RecordInfo info = DNetOAIMongoCursor.this.recordInfoGenerator.transformDBObject(res, DNetOAIMongoCursor.this.bodyIncluded);
                if (DNetOAIMongoCursor.this.function != null && DNetOAIMongoCursor.this.bodyIncluded && info != null) {
                    info.setMetadata((String)DNetOAIMongoCursor.this.function.evaluate((Object)info.getMetadata()));
                }
                return info;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public UnaryFunction<String, String> getFunction() {
        return this.function;
    }

    public void setFunction(UnaryFunction<String, String> function) {
        this.function = function;
    }

    public MongoCursor<DBObject> getDbCursor() {
        return this.dbCursor;
    }

    public void setDbCursor(MongoCursor<DBObject> dbCursor) {
        this.dbCursor = dbCursor;
    }

    @Override
    public boolean isBodyIncluded() {
        return this.bodyIncluded;
    }

    @Override
    public void setBodyIncluded(boolean bodyIncluded) {
        this.bodyIncluded = bodyIncluded;
    }

    public RecordInfoGenerator getRecordInfoGenerator() {
        return this.recordInfoGenerator;
    }

    public void setRecordInfoGenerator(RecordInfoGenerator recordInfoGenerator) {
        this.recordInfoGenerator = recordInfoGenerator;
    }

    public MetadataExtractor getMetadataExtractor() {
        return this.metadataExtractor;
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    public ProvenanceExtractor getProvenanceExtractor() {
        return this.provenanceExtractor;
    }

    public void setProvenanceExtractor(ProvenanceExtractor provenanceExtractor) {
        this.provenanceExtractor = provenanceExtractor;
    }
}

