/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.mongo;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.WriteConcern;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationReader;
import eu.dnetlib.data.oai.store.RecordChangeDetector;
import eu.dnetlib.data.oai.store.mongo.MetadataExtractor;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.RecordInfoGenerator;
import eu.dnetlib.data.oai.store.sets.MongoSetCollection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

public class MongoPublisherCacheHelper {
    private static final Log log = LogFactory.getLog(MongoPublisherCacheHelper.class);
    @Autowired
    private MongoClient publisherMongoClient;
    @Resource(name="oaiConfigurationExistReader")
    private OAIConfigurationReader configuration;
    @Resource
    private MetadataExtractor metadataExtractor;
    @Resource
    private RecordInfoGenerator recordInfoGenerator;
    @Resource
    private RecordChangeDetector recordChangeDetector;

    public MongoDatabase getDB(String dbName) {
        return this.publisherMongoClient.getDatabase(dbName).withWriteConcern(WriteConcern.JOURNALED);
    }

    @Cacheable(value={"oaistores"}, key="#dbname")
    public List<MongoPublisherStore> listPublisherStores(String dbName, String metadataCollectionName, final boolean alwaysNewRecord, final MongoSetCollection mongoSetCollection) {
        log.info((Object)("Not using cache for listPublisherStores on " + dbName));
        final MongoDatabase db = this.getDB(dbName);
        FindIterable stores = db.getCollection(metadataCollectionName, DBObject.class).find();
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)stores, (Function)new Function<DBObject, MongoPublisherStore>(){

            public MongoPublisherStore apply(DBObject storeInfo) {
                return MongoPublisherCacheHelper.this.createFromDBObject(storeInfo, db, alwaysNewRecord, mongoSetCollection);
            }
        }));
    }

    @Cacheable(value={"oaistoresById"}, key="#storeId + #dbName", unless="#result == null")
    public MongoPublisherStore getStoreById(String storeId, String dbName, String metadataCollectionName, boolean alwaysNewRecord, MongoSetCollection mongoSetCollection) {
        log.info((Object)String.format("Not using cache for getStoreById: %s", storeId));
        DBObject storeInfo = (DBObject)this.getDB(dbName).getCollection(metadataCollectionName, DBObject.class).find(Filters.eq((String)"id", (Object)storeId)).first();
        log.info((Object)("Got DBObject from mongo " + dbName + "." + metadataCollectionName + ", id " + storeId + " is : " + storeInfo));
        return this.createFromDBObject(storeInfo, this.getDB(dbName), alwaysNewRecord, mongoSetCollection);
    }

    @CacheEvict(value={"oaistoresById"}, key="#storeId + #dbName")
    public void deleteFromCache(String storeId, String dbName) {
        log.info((Object)("Evicting " + storeId + " for db " + dbName + " from the cache"));
    }

    private MongoPublisherStore createFromDBObject(DBObject storeInfo, MongoDatabase db, boolean alwaysNewRecord, MongoSetCollection mongoSetCollection) {
        if (storeInfo == null) {
            log.error((Object)"cannot create MongoPublisherStore from null DBObject");
            return null;
        }
        log.debug((Object)("Creating MongoPublisherStore from DBObject " + storeInfo.toString()));
        String storeId = (String)storeInfo.get("id");
        String mdFormat = (String)storeInfo.get("metadataFormat");
        String mdInterpreation = (String)storeInfo.get("interpretation");
        String mdLayout = (String)storeInfo.get("layout");
        MongoPublisherStore store = new MongoPublisherStore(storeId, mdFormat, mdInterpreation, mdLayout, (MongoCollection<DBObject>)db.getCollection(storeId, DBObject.class), this.configuration.getFields(mdFormat, mdInterpreation, mdLayout), this.recordInfoGenerator, this.configuration.getIdScheme(), this.configuration.getIdNamespace(), this.metadataExtractor, this.recordChangeDetector, alwaysNewRecord, db);
        store.setMongoSetCollection(mongoSetCollection);
        return store;
    }
}

