/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.mongo;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.PublisherStoreDAO;
import eu.dnetlib.data.oai.store.mongo.DNetOAIMongoCursor;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherCacheHelper;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.sets.MongoSetCollection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class MongoPublisherStoreDAO
implements PublisherStoreDAO<MongoPublisherStore, DNetOAIMongoCursor> {
    private static final Log log = LogFactory.getLog(MongoPublisherStoreDAO.class);
    @Autowired
    private MongoPublisherCacheHelper mongoCacheHelper;
    private String metadataCollection;
    @Resource
    private MongoSetCollection mongoSetCollection;
    private boolean alwaysNewRecord;
    @Resource(name="oaiConfigurationExistReader")
    private OAIConfigurationReader configuration;

    @Override
    public List<MongoPublisherStore> listPublisherStores(String dbName) {
        return this.mongoCacheHelper.listPublisherStores(dbName, this.metadataCollection, this.alwaysNewRecord, this.mongoSetCollection);
    }

    @Override
    public MongoPublisherStore getStore(String storeId, String dbName) {
        return this.mongoCacheHelper.getStoreById(storeId, dbName, this.metadataCollection, this.alwaysNewRecord, this.mongoSetCollection);
    }

    @Override
    public MongoPublisherStore getStore(String mdfName, String mdfInterpretation, String mdfLayout, String dbName) {
        return this.getStore(this.generateStoreId(mdfName, mdfInterpretation, mdfLayout), dbName);
    }

    @Override
    public MongoPublisherStore getStoreFor(String targetMetadataPrefix, String dbName) {
        MDFInfo info = this.configuration.getMetadataFormatInfo(targetMetadataPrefix);
        MongoPublisherStore store = this.getStore(info.getSourceFormatName(), info.getSourceFormatInterpretation(), info.getSourceFormatLayout(), dbName);
        return store;
    }

    @Override
    public MongoPublisherStore createStore(String mdfName, String mdfInterpretation, String mdfLayout, String dbName) throws OaiPublisherException {
        log.debug((Object)"CREATING OAI STORE");
        MongoDatabase db = this.mongoCacheHelper.getDB(dbName);
        DBObject store = this.createMetadataEntry(mdfName, mdfInterpretation, mdfLayout);
        MongoCollection metadata = db.getCollection(this.metadataCollection, DBObject.class);
        String id = (String)store.get("id");
        metadata.insertOne((Object)store);
        log.debug((Object)("metadata insert done for store " + id));
        MongoPublisherStore theStore = this.mongoCacheHelper.getStoreById(id, dbName, this.metadataCollection, this.alwaysNewRecord, this.mongoSetCollection);
        return theStore;
    }

    @Override
    public boolean deleteStore(String storeId, String dbName) {
        log.debug((Object)("DELETING OAI STORE " + storeId + " -- db: " + dbName));
        this.mongoCacheHelper.deleteFromCache(storeId, dbName);
        MongoDatabase db = this.mongoCacheHelper.getDB(dbName);
        MongoCollection metadata = db.getCollection(this.metadataCollection, DBObject.class);
        DBObject storeDeleted = (DBObject)metadata.findOneAndDelete(Filters.eq((String)"id", (Object)storeId));
        if (storeDeleted == null) {
            return false;
        }
        db.getCollection(storeId).drop();
        this.mongoSetCollection.dropOAISets(dbName);
        log.debug((Object)("Deleted oaistore " + storeId + ", db: " + dbName));
        return true;
    }

    @Override
    public boolean deleteFromStore(String storeId, String dbName, String set) {
        log.debug((Object)String.format("DELETING OAI STORE %s BY SET %s from db %s", storeId, set, dbName));
        this.mongoCacheHelper.deleteFromCache(storeId, dbName);
        MongoDatabase db = this.mongoCacheHelper.getDB(dbName);
        MongoCollection metadata = db.getCollection(this.metadataCollection, DBObject.class);
        DBObject storeInfo = (DBObject)metadata.find(Filters.eq((String)"id", (Object)storeId)).first();
        if (storeInfo == null) {
            return false;
        }
        db.getCollection(storeId).deleteOne(Filters.eq((String)"set", (Object)set));
        this.mongoSetCollection.dropSet(dbName, set);
        log.debug((Object)("Deleted set " + set + " from oaistore " + storeId + ", db: " + dbName));
        return true;
    }

    @Override
    public boolean deleteFromStore(String mdfName, String mdfInterpretation, String mdfLayout, String dbName, String set) {
        return this.deleteFromStore(this.generateStoreId(mdfName, mdfInterpretation, mdfLayout), dbName, set);
    }

    @Override
    public boolean deleteStore(String mdfName, String mdfInterpretation, String mdfLayout, String dbName) {
        return this.deleteStore(this.generateStoreId(mdfName, mdfInterpretation, mdfLayout), dbName);
    }

    public void ensureIndex(final MongoPublisherStore store) {
        if (store == null) {
            throw new OaiPublisherRuntimeException("Can't ensure index on null store");
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                store.ensureIndices();
            }
        };
        t.start();
    }

    public void ensureIndex(String dbName) {
        List<MongoPublisherStore> stores = this.listPublisherStores(dbName);
        for (MongoPublisherStore s : stores) {
            s.ensureIndices();
        }
    }

    private DBObject createMetadataEntry(String mdfName, String mdfInterpretation, String mdfLayout) {
        DBObject info = BasicDBObjectBuilder.start((String)"id", (Object)this.generateStoreId(mdfName, mdfInterpretation, mdfLayout)).append("metadataFormat", (Object)mdfName).append("interpretation", (Object)mdfInterpretation).append("layout", (Object)mdfLayout).get();
        log.debug((Object)("Created DBObject for OAIStore metadata entry: " + info.toString()));
        return info;
    }

    private String generateStoreId(String mdfName, String mdfInterpretation, String mdfLayout) {
        return mdfName + "-" + mdfLayout + "-" + mdfInterpretation;
    }

    public String getMetadataCollection() {
        return this.metadataCollection;
    }

    @Required
    public void setMetadataCollection(String metadataCollection) {
        this.metadataCollection = metadataCollection;
    }

    public OAIConfigurationReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAIConfigurationReader configuration) {
        this.configuration = configuration;
    }

    public MongoSetCollection getMongoSetCollection() {
        return this.mongoSetCollection;
    }

    public void setMongoSetCollection(MongoSetCollection mongoSetCollection) {
        this.mongoSetCollection = mongoSetCollection;
    }

    public boolean isAlwaysNewRecord() {
        return this.alwaysNewRecord;
    }

    public void setAlwaysNewRecord(boolean alwaysNewRecord) {
        this.alwaysNewRecord = alwaysNewRecord;
    }
}

