/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.sets;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.information.oai.sets.SetCollection;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;

public class MongoSetCollection
implements SetCollection {
    public static String DEFAULT_SET = "OTHER";
    @Autowired
    private MongoClient publisherMongoClient;
    private String setCollection = "sets";
    private String setCountCollection = "setsCount";

    public void ensureIndexes(String dbName) {
        this.ensureIndexesOnSets(dbName);
        this.ensureIndexesOnCount(dbName);
    }

    public List<SetInfo> getAllSets(boolean enabledOnly, String dbName) {
        FindIterable iter = null;
        if (!enabledOnly) {
            iter = this.getSetsCollection(dbName).find();
        } else {
            Bson where = Filters.eq((String)"enabled", (Object)true);
            iter = this.getSetsCollection(dbName).find(where);
        }
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)iter, (Function)new Function<DBObject, SetInfo>(){

            public SetInfo apply(DBObject dbObject) {
                return MongoSetCollection.this.getSetFromDBObject(dbObject);
            }
        }));
    }

    public boolean containSet(String set, String dbName) {
        Bson query = Filters.eq((String)"spec", (Object)set);
        return this.getSetsCollection(dbName).count(query) != 0L;
    }

    public boolean containEnabledSet(String set, String publisherDBName) {
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)"spec", (Object)set), Filters.eq((String)"enabled", (Object)true)});
        return this.getSetsCollection(publisherDBName).count(query) != 0L;
    }

    public String getSetQuery(String set, String dbName) {
        Bson query = Filters.eq((String)"spec", (Object)set);
        BasicDBObject returnField = new BasicDBObject("query", (Object)1);
        DBObject obj = (DBObject)this.getSetsCollection(dbName).find(query).projection((Bson)returnField).first();
        return (String)obj.get("query");
    }

    public int count(String setSpec, String mdPrefix, String dbName) {
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)"spec", (Object)setSpec), Filters.eq((String)"mdPrefix", (Object)mdPrefix)});
        BasicDBObject returnField = new BasicDBObject("count", (Object)1);
        DBObject obj = (DBObject)this.getSetsCountCollection(dbName).find(query).projection((Bson)returnField).first();
        if (obj == null) {
            return 0;
        }
        return (Integer)obj.get("count");
    }

    public void updateCounts(String setSpec, String mdPrefix, int count, String dbName) {
        BasicDBObject countUpdate = new BasicDBObject("$set", (Object)new BasicDBObject("count", (Object)count));
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)"spec", (Object)setSpec), Filters.eq((String)"mdPrefix", (Object)mdPrefix)});
        this.getSetsCountCollection(dbName).findOneAndUpdate(query, (Bson)countUpdate, new FindOneAndUpdateOptions().upsert(true));
    }

    public void upsertSet(SetInfo setInfo, boolean fromConfiguration, String dbName) {
        DBObject obj = this.getObjectFromSet(setInfo);
        obj.put("fromConfiguration", (Object)fromConfiguration);
        this.getSetsCollection(dbName).findOneAndReplace(Filters.eq((String)"spec", (Object)setInfo.getSetSpec()), (Object)obj, new FindOneAndReplaceOptions().upsert(true));
    }

    public String normalizeSetSpec(String setName) {
        String s = StringEscapeUtils.unescapeXml((String)setName);
        s = Normalizer.normalize(s, Normalizer.Form.NFD);
        s = s.replaceAll(" ", "_");
        s = s.replaceAll("[\\p{InCombiningDiacriticalMarks}&&[^-_]]", "");
        s = s.replaceAll("[\\p{Punct}&&[^-_]]", "_");
        String stripped = StringUtils.strip((String)(s = s.replaceAll("[\\W&&[^-_]]", "")), (String)"_ ");
        if (StringUtils.isBlank((String)stripped)) {
            stripped = DEFAULT_SET;
        }
        return stripped;
    }

    public List<SetInfo> getConfiguredSets(String dbName) {
        Bson query = Filters.eq((String)"fromConfiguration", (Object)true);
        return this.findSets(query, dbName);
    }

    public List<SetInfo> getSetsFromData(String dbName) {
        Bson query = Filters.eq((String)"fromConfiguration", (Object)false);
        return this.findSets(query, dbName);
    }

    public void dropOAISets(String dbName) {
        this.getSetsCountCollection(dbName).drop();
        this.getSetsCollection(dbName).drop();
    }

    public void dropSet(String dbName, String setSpec) {
        Bson query = Filters.eq((String)"spec", (Object)setSpec);
        this.getSetsCollection(dbName).deleteMany(query);
        this.getSetsCountCollection(dbName).deleteMany(query);
    }

    public void dropConfigurationSets(String dbName) {
        this.getSetsCollection(dbName).deleteMany(Filters.eq((String)"fromConfiguration", (Object)true));
    }

    protected List<SetInfo> findSets(Bson query, String dbName) {
        FindIterable sets = this.getSetsCollection(dbName).find(query);
        ArrayList res = Lists.newArrayList();
        for (DBObject obj : sets) {
            res.add(this.getSetFromDBObject(obj));
        }
        return res;
    }

    private SetInfo getSetFromDBObject(DBObject obj) {
        SetInfo setInfo = new SetInfo();
        setInfo.setEnabled(((Boolean)obj.get("enabled")).booleanValue());
        setInfo.setQuery((String)obj.get("query"));
        setInfo.setSetDescription((String)obj.get("description"));
        setInfo.setSetName((String)obj.get("name"));
        setInfo.setSetSpec((String)obj.get("spec"));
        return setInfo;
    }

    private DBObject getObjectFromSet(SetInfo s) {
        DBObject obj = BasicDBObjectBuilder.start((String)"spec", (Object)s.getSetSpec()).add("name", (Object)s.getSetName()).add("description", (Object)s.getSetDescription()).add("query", (Object)s.getQuery()).add("enabled", (Object)s.isEnabled()).get();
        return obj;
    }

    private void ensureIndexesOnSets(String dbName) {
        this.getSetsCollection(dbName).createIndex((Bson)new BasicDBObject("spec", (Object)1), new IndexOptions().background(true));
        this.getSetsCollection(dbName).createIndex((Bson)new BasicDBObject("fromConfiguration", (Object)1), new IndexOptions().background(true));
    }

    private void ensureIndexesOnCount(String dbName) {
        BasicDBObject index = (BasicDBObject)BasicDBObjectBuilder.start((String)"spec", (Object)1).add("mdPrefix", (Object)1).get();
        this.getSetsCountCollection(dbName).createIndex((Bson)index, new IndexOptions().background(true));
    }

    public MongoCollection<DBObject> getSetsCollection(String dbName) {
        return this.getCollection(this.setCollection, dbName);
    }

    public MongoCollection<DBObject> getSetsCountCollection(String dbName) {
        return this.getCollection(this.setCountCollection, dbName);
    }

    private MongoCollection<DBObject> getCollection(String collectionName, String dbName) {
        return this.publisherMongoClient.getDatabase(dbName).getCollection(collectionName, DBObject.class);
    }

    public String getSetCollection() {
        return this.setCollection;
    }

    public void setSetCollection(String setCollection) {
        this.setCollection = setCollection;
    }

    public String getSetCountCollection() {
        return this.setCountCollection;
    }

    public void setSetCountCollection(String setCountCollection) {
        this.setCountCollection = setCountCollection;
    }

    public MongoClient getPublisherMongoClient() {
        return this.publisherMongoClient;
    }

    public void setPublisherMongoClient(MongoClient publisherMongoClient) {
        this.publisherMongoClient = publisherMongoClient;
    }
}

