/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.sync;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationExistReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OAIStoreSynchronizer {
    private static final Log log = LogFactory.getLog(OAIStoreSynchronizer.class);
    @Resource
    private OAIConfigurationExistReader configuration;
    @Autowired
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;

    public void synchronize(Iterable<String> records, MDFInfo sourceMetadataFormat, String recordSource, String dbName, boolean alwaysNewRecord, Callable<?> callback, Callable<?> failCallback) {
        try {
            log.fatal((Object)("Synchronizing content for source metadata format " + sourceMetadataFormat));
            MongoPublisherStore store = this.getStore(sourceMetadataFormat, dbName, alwaysNewRecord);
            int count = store.feed(records, recordSource);
            log.info((Object)("Content synchronized: store " + sourceMetadataFormat + " fed with " + count + " records"));
            this.executeCallback(callback);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.executeCallback(failCallback);
        }
    }

    private MongoPublisherStore getStore(MDFInfo sourceMetadataFormat, String dbName, boolean alwaysNewRecord) {
        this.mongoPublisherStoreDAO.setAlwaysNewRecord(alwaysNewRecord);
        MongoPublisherStore store = this.mongoPublisherStoreDAO.getStore(sourceMetadataFormat.getSourceFormatName(), sourceMetadataFormat.getSourceFormatInterpretation(), sourceMetadataFormat.getSourceFormatLayout(), dbName);
        if (store == null) {
            log.debug((Object)("Creating store for metadata format: \n" + sourceMetadataFormat + " in db: " + dbName));
            try {
                store = this.mongoPublisherStoreDAO.createStore(sourceMetadataFormat.getSourceFormatName(), sourceMetadataFormat.getSourceFormatInterpretation(), sourceMetadataFormat.getSourceFormatLayout(), dbName);
                log.debug((Object)("Created store with id: " + store.getId()));
            }
            catch (OaiPublisherException e) {
                throw new OaiPublisherRuntimeException((Throwable)e);
            }
        }
        return store;
    }

    protected void executeCallback(Callable<?> callback) {
        if (callback != null) {
            try {
                callback.call();
            }
            catch (Exception e) {
                log.error((Object)"Error executing callback", (Throwable)e);
            }
        }
    }

    public OAIConfigurationExistReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAIConfigurationExistReader configuration) {
        this.configuration = configuration;
    }
}

