package eu.dnetlib.data.oai.store;

public interface RecordChangeDetector {

	/**
	 * Checks if the two records have differences based on logics that vary on the actual implementor class.
	 * 
	 * @param record1
	 *            first record to compare
	 * @param record2
	 *            second record to compare
	 * @return true if the two records differ based on the implementor's logics
	 */
	boolean differs(final String record1, final String record2);
}
