package eu.dnetlib.data.oai.store.actions;

import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.data.oai.store.conf.OAISetHelper;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class RefreshConfigAction extends AbstractOAIStoreAction {

	@Autowired
	private OAISetHelper oaiSetHelper;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		String dbName = job.getParameters().get("oai_dbName");
		oaiSetHelper.loadConfiguration(dbName);
		handler.done(job);
	}

	public OAISetHelper getOaiSetHelper() {
		return oaiSetHelper;
	}

	public void setOaiSetHelper(final OAISetHelper oaiSetHelper) {
		this.oaiSetHelper = oaiSetHelper;
	}

}
