package eu.dnetlib.data.oai.store.actions;

import java.util.concurrent.Callable;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.ClassPathResource;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;

import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.sync.OAIStoreSynchronizer;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;

public class SyncAction extends AbstractOAIStoreAction {

	private static final Log log = LogFactory.getLog(SyncAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private OAIStoreSynchronizer synchronizer;
	@Resource
	private ResultSetClientFactory resultSetClientFactory;
	org.springframework.core.io.Resource dmfXsltResource = new ClassPathResource("/eu/dnetlib/data/oai/store/xslt/addDMFBlock.xslt");
	private final SAXReader saxReader = new SAXReader();

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		EPRUtils eprUtils = new EPRUtils();
		W3CEndpointReference epr = eprUtils.getEpr(job.getParameters().get("oai_syncEpr"));
		String recordSource = job.getParameters().get("oai_recordSource");
		String formatName = job.getParameters().get("oai_formatName");
		String formatLayout = job.getParameters().get("oai_formatLayout");
		String formatInterpretation = job.getParameters().get("oai_formatInterpretation");
		boolean alwaysNewRecord = Boolean.valueOf(job.getParameters().get("oai_alwaysNewRecord"));
		final String dbName = job.getParameters().get("oai_dbName");
		MDFInfo mdf = new MDFInfo("", "", "", formatName, formatLayout, formatInterpretation, "", true);
		IterableResultSetClient client = resultSetClientFactory.getClient(epr);
		log.info("Syncronizing content for oai on db " + dbName + "for metadata format: " + mdf);
		Iterable<String> records = client;
		// in case of DMF there is no "hat element" after oai:metadata: we must add it or the OAI-PMH export will only contain the first
		// element inside oai:metadata.
		if (formatName.equalsIgnoreCase("DMF")) {
			records = addDMFBlock(client);
		}
		this.synchronizer.synchronize(records, mdf, recordSource, dbName, alwaysNewRecord, new Callable<Object>() {

			@Override
			public Object call() {
				handler.done(job);
				return null;
			}
		}, new Callable<Object>() {

			@Override
			public Object call() {
				handler.failed(job, new Exception("Error during OAI synchronization on db " + dbName));
				return null;
			}
		});

	}

	protected Iterable<String> addDMFBlock(final Iterable<String> input) {
		final ApplyXslt addDMFBlockXslt = new ApplyXslt(dmfXsltResource);
		return Iterables.transform(input, new Function<String, String>() {

			@Override
			public String apply(final String dmfRecord) {
				return addDMFBlockXslt.evaluate(dmfRecord);
			}
		});
	}

	public OAIStoreSynchronizer getSynchronizer() {
		return synchronizer;
	}

	public void setSynchronizer(final OAIStoreSynchronizer synchronizer) {
		this.synchronizer = synchronizer;
	}

	public ResultSetClientFactory getRsClientFactory() {
		return resultSetClientFactory;
	}

	public void setRsClientFactory(final ResultSetClientFactory rsClientFactory) {
		this.resultSetClientFactory = rsClientFactory;
	}

}
