package eu.dnetlib.data.oai.store.mongo;

import eu.dnetlib.miscutils.functional.UnaryFunction;
import org.dom4j.Document;
import org.dom4j.Node;

/**
 * Function to skip the header of the record and deliver only its metadata content as XML String.
 */
public class MetadataExtractor implements UnaryFunction<String, Document> {

	@Override
	public String evaluate(final Document xmlDoc) {
		Node metadataNode = xmlDoc.selectSingleNode("//*[local-name() = 'metadata']/*");
		//Node metadataNode = xmlDoc.selectSingleNode("/*[local-name()='record']/*[local-name() = 'metadata']/*");
		return metadataNode.asXML();
	}
}
