package eu.dnetlib.data.oai.store.mongo;

import eu.dnetlib.miscutils.functional.UnaryFunction;
import org.dom4j.Document;
import org.dom4j.Node;

/**
 * Function to deliver only the about/provenance content of a record as XML String.
 */
public class ProvenanceExtractor implements UnaryFunction<String, Document> {

	@Override
	public String evaluate(final Document xmlDoc) {
		//	Node provenanceNode = xmlDoc.selectSingleNode("//*[local-name() = 'about']/*[local-name() = 'provenance']");
		Node provenanceNode = xmlDoc.selectSingleNode("/*[local-name()='record']/*[local-name() = 'about']/*[local-name() = 'provenance']");
		if (provenanceNode != null) return provenanceNode.asXML();
		else return null;
	}
}
