/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.model.DocumentBuilder;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldDef;
import eu.dnetlib.pace.model.FieldListImpl;
import eu.dnetlib.pace.model.FieldValueImpl;
import eu.dnetlib.pace.model.MapDocument;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ProtoDocumentBuilder
extends DocumentBuilder {
    public static MapDocument newInstance(String id, GeneratedMessage proto, List<FieldDef> fields) {
        Map<String, FieldListImpl> fieldMap = new ProtoDocumentBuilder().generateFieldMap(proto, fields);
        return ProtoDocumentBuilder.newInstance((String)id, fieldMap);
    }

    private Map<String, FieldListImpl> generateFieldMap(GeneratedMessage proto, List<FieldDef> fields) {
        HashMap fieldMap = Maps.newHashMap();
        for (FieldDef fd : fields) {
            fieldMap.put(fd.getName(), this.processPath(fd.getName(), proto, fd.getPathList()));
        }
        return fieldMap;
    }

    public FieldListImpl processPath(String name, GeneratedMessage proto, List<String> list) {
        FieldListImpl response = new FieldListImpl(name);
        if (list.isEmpty()) {
            throw new RuntimeException("ProtoBuf navigation path is empty");
        }
        Descriptors.FieldDescriptor desc = proto.getDescriptorForType().findFieldByName(list.get(0));
        if (desc != null) {
            if (desc.isRepeated()) {
                int count = proto.getRepeatedFieldCount(desc);
                for (int i = 0; i < count; ++i) {
                    Object field = proto.getRepeatedField(desc, i);
                    if (this.mustSkip(desc, field)) continue;
                    response.addAll(this.generateFields(name, field, list));
                }
            } else {
                Object field = proto.getField(desc);
                if (!this.mustSkip(desc, field)) {
                    response.addAll(this.generateFields(name, field, list));
                }
            }
        } else {
            throw new RuntimeException("Invalid protobuf path (field not found): " + StringUtils.join(list, (String)">"));
        }
        return response;
    }

    private boolean mustSkip(Descriptors.FieldDescriptor desc, Object field) {
        if (desc.getName().equals("title") && !((FieldTypeProtos.StructuredProperty)field).getQualifier().getClassid().equals("main title")) {
            return true;
        }
        return desc.getName().equals("pid") && !((FieldTypeProtos.StructuredProperty)field).getQualifier().getClassid().equals("doi");
    }

    private List<Field> generateFields(String name, Object field, List<String> list) {
        if (field instanceof GeneratedMessage) {
            if (list.size() > 1) {
                return this.processPath(name, (GeneratedMessage)field, list.subList(1, list.size()));
            }
            throw new RuntimeException("No primitive type found");
        }
        if (list.size() == 1) {
            Type type = field instanceof Integer ? Type.Int : Type.String;
            return Lists.newArrayList((Iterable)new FieldValueImpl(type, name, field));
        }
        throw new RuntimeException("Found a primitive type before the path end");
    }
}

