package eu.dnetlib.data.mapreduce.util;

import com.google.protobuf.Descriptors.FieldDescriptor;
import com.google.protobuf.GeneratedMessage;

import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.TypeProtos.Type;

public class OafEntityDecoder {

	private final OafEntity oafEntity;

	public static OafEntityDecoder decode(OafEntity oafEntity) {
		return new OafEntityDecoder(oafEntity);
	}

	private OafEntityDecoder(OafEntity oafEntity) {
		this.oafEntity = oafEntity;
	}

	public Type getType() {
		return oafEntity.getType();
	}

	public String getId() {
		return oafEntity.getId();
	}

	public GeneratedMessage getOafEntity() {
		return oafEntity;
	}

	public GeneratedMessage getEntity() {
		FieldDescriptor fd = oafEntity.getDescriptorForType().findFieldByName(typeName());
		return (GeneratedMessage) oafEntity.getField(fd);
	}

	public String typeName() {
		return oafEntity.getType().toString();
	}

	public GeneratedMessage getMetadata() {
		GeneratedMessage entity = getEntity();
		FieldDescriptor fd = entity.getDescriptorForType().findFieldByName("metadata");
		GeneratedMessage field = (GeneratedMessage) entity.getField(fd);
		return field;
	}

	public String getDateOfCollection() {
		return oafEntity.getDateofcollection();
	}
}
