package eu.dnetlib.actionmanager.actions.infopackage;

import org.w3c.dom.NodeList;

import eu.dnetlib.data.transform.xml.DataciteToHbaseXsltFunctions;

public class DataciteInfoPackageToHbaseXsltFunctions extends DataciteToHbaseXsltFunctions {

	public static String oafDataCiteResultFromInfoPackage(final String resultId,
			final NodeList dataInfo,
			final NodeList metadata,
			final NodeList titles,
			final NodeList subjects,
			final NodeList publisher,
			final NodeList descriptions,
			final NodeList dates,
			final NodeList dateaccepted,
			final NodeList resourceTypes,
			final NodeList formats,
			final NodeList sizes,
			final NodeList languages,
			final NodeList cobjcategory,
			final NodeList rights,
			final NodeList version,
			final String provenance,
			final String trust,
			final String hostedbyId,
			final String hostedbyName,
			final String collectedfromId,
			final String collectedfromName,
			final String originalId,
			final String instanceUri,
			final String dateOfCollection) {

		return oafResult_FromDatacite(resultId, dataInfo, metadata, titles, subjects, publisher, descriptions, dates, dateaccepted, resourceTypes, formats,
				sizes, languages, cobjcategory, rights, version, provenance, trust, hostedbyId, hostedbyName, collectedfromId, collectedfromName, originalId,
				instanceUri, dateOfCollection);

	}

	public static String oafDataCitePersonFromInfoPackage(final String personId,
			final NodeList dataInfo,
			final String fullname,
			final String provenanceAction,
			final String trust,
			final String collectedfromId,
			final String collectedfromName,
			final String originalId,
			final String dateOfCollection) {

		return oafPerson_FromDatacite(personId, dataInfo, fullname, provenanceAction, trust, collectedfromId, collectedfromName, originalId, dateOfCollection);

	}

	public static String oafDataCitePersonResultFromInfoPackage(final String personId,
			final String resultId,
			final int rank,
			final String relClass,
			final String provenanceAction,
			final String trust,
			final NodeList dataInfo) {
		return oafPersonResult_Authorship_FromDatacite(personId, resultId, rank, relClass, provenanceAction, trust, dataInfo);
	}

	public static String oafDataCitePublicationDatasetFromInfoPackage(final String sourceId,
			final String targetId,
			final String relClass,
			final String provenanceAction,
			final String trust,
			final NodeList dataInfo) {
		return oafResultResult_PublicationDataset_FromDatacite(sourceId, targetId, relClass, provenanceAction, trust, dataInfo);
	}

}
