/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import eu.dnetlib.data.proto.TypeProtos;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;

public class OafRowKeyDecoder {
    private static final Log log = LogFactory.getLog(OafRowKeyDecoder.class);
    private static final String SEPARATOR = "|";
    public static final String ID_REGEX = "^[0-9][0-9]\\|.{12}::[a-zA-Z0-9]{32}$";
    private String key;
    private TypeProtos.Type type = null;
    private String id = null;

    public static OafRowKeyDecoder decode(byte[] key) throws IllegalArgumentException {
        return new OafRowKeyDecoder(new String(key));
    }

    public static OafRowKeyDecoder decode(String key) throws IllegalArgumentException {
        return new OafRowKeyDecoder(key);
    }

    private OafRowKeyDecoder(String key) throws IllegalArgumentException {
        this.key = key;
        if (!key.matches(ID_REGEX)) {
            String msg = "invalid key: '" + key + "'";
            log.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        int tag = Integer.parseInt(StringUtils.substringBefore((String)key, (String)SEPARATOR));
        this.type = TypeProtos.Type.valueOf((int)tag);
        this.id = StringUtils.substringAfter((String)key, (String)SEPARATOR);
    }

    public String getKey() {
        return this.key;
    }

    public Text getKeyAsText() {
        return new Text(this.key);
    }

    public TypeProtos.Type getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }
}

