package eu.dnetlib.data.index;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.response.SolrPingResponse;

/**
 * Created by michele on 11/11/15.
 */
public class CloudIndexClientFactory {

	private static final Log log = LogFactory.getLog(CloudIndexClientFactory.class);

	public static CloudIndexClient newIndexClient(final String baseURL, final String collection, final boolean parallelUpdates)
			throws CloudIndexClientException {
		CloudSolrServer solrServer = null;
		try {

			log.info(String.format("Initializing solr server (%s) ...", baseURL));
			solrServer = new CloudSolrServer(baseURL);

			solrServer.connect();

			solrServer.setParallelUpdates(parallelUpdates);
			solrServer.setDefaultCollection(collection);

			final SolrPingResponse rsp = solrServer.ping();
			if (rsp.getStatus() != 0) {
				log.error("Invalid connection to solr Server (status = 0)");
				throw new CloudIndexClientException("Invalid connection to solr Server (status = 0)");
			}

			return new CloudIndexClient(solrServer);
		} catch (Throwable e) {
			if (solrServer != null) {
				solrServer.shutdown();
			}
			log.error("The initialization of indexClient is FAILED", e);
			throw new CloudIndexClientException("The initialization of indexClient is FAILED", e);
		}
	}
}
