package eu.dnetlib.openaire.exporter.model;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;

import com.google.gson.Gson;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.io.CsvBeanReader;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.io.ICsvBeanReader;
import org.supercsv.io.ICsvBeanWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CsvContext;

/**
 * Created by claudio on 22/09/16.
 */
public class ProjectDetail {

	private static final String[] NAMEMAPPING = { "projectId", "acronym", "code", "optional1", "optional2", "jsonextrainfo", "fundingPath" };

	private String projectId;
	private String acronym;
	private String code;
	private String optional1;
	private String optional2;
	private String jsonextrainfo;
	private List<String> fundingPath;

	public ProjectDetail() {}

	public static ProjectDetail fromJson(final String json) {
		return new Gson().fromJson(json, ProjectDetail.class);
	}

	public static ProjectDetail fromCSV(final String csv) throws IOException {
		ICsvBeanReader beanReader = null;
		try {
			beanReader = new CsvBeanReader(new StringReader(csv), CsvPreference.STANDARD_PREFERENCE);
			return beanReader.read(ProjectDetail.class, NAMEMAPPING, getProcessors(new StringCellProcessor() {
				@Override
				public Object execute(final Object value, final CsvContext context) {
					return new Gson().fromJson(value.toString(), List.class);
				}
			}));
		} finally {
			if (beanReader != null) {
				beanReader.close();
			}
		}
	}

	/**
	 * Sets up the processors used for the examples. There are 10 CSV columns, so 10 processors are defined. Empty
	 * columns are read as null (hence the NotNull() for mandatory columns).
	 *
	 * @return the cell processors
	 */
	private static CellProcessor[] getProcessors(final CellProcessor fundingPathProcessor) {
		return new CellProcessor[] {
				new Optional(), // projectId
				new Optional(), // acronym
				new Optional(), // code
				new Optional(), // optional1
				new Optional(), // optional2
				new Optional(), // jsonextrainfo
				fundingPathProcessor
		};
	}

	public String asJson() {
		return new Gson().toJson(this) + '\n';
	}

	public String asCSV() throws IOException {
		final StringWriter sb = new StringWriter();
		try (ICsvBeanWriter beanWriter = new CsvBeanWriter(sb, CsvPreference.STANDARD_PREFERENCE)) {
			beanWriter.write(this, NAMEMAPPING, getProcessors(new StringCellProcessor() {
				@Override
				public Object execute(final Object value, final CsvContext context) {
					return new Gson().toJson(value);
				}
			}));
			beanWriter.flush();
		}

		return sb.toString();
	}

	public String getProjectId() {
		return projectId;
	}

	public ProjectDetail setProjectId(final String projectId) {
		this.projectId = projectId;
		return this;
	}

	public String getAcronym() {
		return acronym;
	}

	public ProjectDetail setAcronym(final String acronym) {
		this.acronym = acronym;
		return this;
	}

	public String getCode() {
		return code;
	}

	public ProjectDetail setCode(final String code) {
		this.code = code;
		return this;
	}

	public String getOptional1() {
		return optional1;
	}

	public ProjectDetail setOptional1(final String optional1) {
		this.optional1 = optional1;
		return this;
	}

	public String getOptional2() {
		return optional2;
	}

	public ProjectDetail setOptional2(final String optional2) {
		this.optional2 = optional2;
		return this;
	}

	public String getJsonextrainfo() {
		return jsonextrainfo;
	}

	public ProjectDetail setJsonextrainfo(final String jsonextrainfo) {
		this.jsonextrainfo = jsonextrainfo;
		return this;
	}

	public List<String> getFundingPath() {
		return fundingPath;
	}

	public ProjectDetail setFundingPath(final List<String> fundingPath) {
		this.fundingPath = fundingPath;
		return this;
	}

}
