<?xml version="1.0" encoding="UTF-8"?>
<RESOURCE_PROFILE>
	<HEADER>
		<RESOURCE_IDENTIFIER value="eab4c820-e11f-4406-8b01-d31cfcccdf5f_VHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZXMvVHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZVR5cGU="/>
		<RESOURCE_TYPE value="TransformationRuleDSResourceType"/>
		<RESOURCE_KIND value="TransformationRuleDSResources"/>
		<RESOURCE_URI value=""/>
		<DATE_OF_CREATION value="2016-05-08T23:27:01+01:00"/>
	</HEADER>
	<BODY>
		<CONFIGURATION>
			<IMPORTED/>
			<SCRIPT>
				<TITLE>xslt_opentrials_datacite</TITLE>
				<CODE>
					<![CDATA[
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
    xmlns:oai="http://www.openarchives.org/OAI/2.0/" xmlns:oaf="http://namespace.openaire.eu/oaf"
    xmlns:dri="http://www.driver-repository.eu/namespace/dri"
    xmlns:dr="http://www.driver-repository.eu/namespace/dr"
    xmlns:openTrials="eu.dnetlib.data.transform.xml.OpenTrialsXsltFunctions"
    xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="openTrials date"
    exclude-result-prefixes="xsl">

    <xsl:output indent="yes"/>
    <xsl:param name="varOfficialName"/>
    <xsl:param name="varDataSourceId"/>

    <xsl:template match="/">
        <xsl:call-template name="createRecord"/>
    </xsl:template>

    <xsl:template name="createRecord">
        <oai:record>
            <oai:header>
                <xsl:copy-of select="//*[local-name() = 'header']/*" copy-namespaces="no"/>
                <dr:dateOfTransformation>
                    <xsl:value-of select="date:date-time()"/>
                </dr:dateOfTransformation>
            </oai:header>
            <oai:metadata>
                <resource xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                    xsi:schemaLocation="http://datacite.org/schema/kernel-3 http://schema.datacite.org/meta/kernel-3/metadata.xsd"
                    xmlns="http://datacite.org/schema/kernel-3">
                    <!--
                        In order to the web URL to be properly set in the OAF final record, the main id must be an URL.
                        Primary and secondary ids + identifiers can be set as alternate identifiers
                    -->
                    <identifier identifierType="URL">
                        <xsl:value-of
                            select="openTrials:getMainIdentifierURL(//column[@name = 'jsonprov']/text())"/>
                    </identifier>
                    <xsl:variable name="primaryId" select="//column[./@name = 'primary_id']/text()"/>
                    <alternateIdentifiers>
                        <alternateIdentifier
                            alternateIdentifierType="{//column[./@name='primary_register']/text()}">
                            <xsl:value-of select="$primaryId"/>
                        </alternateIdentifier>
                        <!--
                        TODO: handle other ids in alternateIdentifiers. For now secondary_ids are not of our concern (as said by Evgeny from OpenTrials)
                        But identifiers is relevant instead.
                        <column name="secondary_ids">{"others": null}</column>
                        <column name="identifiers">{NCT00972270, XXX}</column>
                        -->
                        <!-- remove '{' and '}' -->
                        <xsl:variable name="cleanedIds"
                            select="replace(replace(//column[@name = 'identifiers'], '\{', ''), '\}', '')"/>
                        <xsl:for-each select="tokenize($cleanedIds, ',')">
                            <xsl:if test="not(. = $primaryId)">
                            <alternateIdentifier>
                                <xsl:value-of select="normalize-space(.)"/>
                            </alternateIdentifier>
                            </xsl:if>
                        </xsl:for-each>
                    </alternateIdentifiers>
                    <!-- No creators available -->
                    <creators/>
                    <titles>
                        <xsl:variable name="scientificTitle"
                            select="normalize-space(//column[@name = 'scientific_title'])"/>
                        <xsl:variable name="publicTitle"
                            select="normalize-space(//column[@name = 'public_title'])"/>
                        <xsl:if test="string-length($scientificTitle) &gt; 0">
                            <title>
                                <xsl:value-of select="$scientificTitle"/>
                            </title>
                        </xsl:if>
                        <xsl:if test="string-length($publicTitle) &gt; 0">
                            <title>
                                <xsl:value-of select="$publicTitle"/>
                            </title>
                        </xsl:if>
                    </titles>
                    <publisher>
                        <xsl:value-of select="//column[./@name = 'primary_register']/text()"/>
                    </publisher>
                    <resourceType resourceTypeGeneral="clinicalTrial">clinical trial</resourceType>
                    <descriptions>
                        <xsl:variable name="description"
                            select="normalize-space(//column[@name = 'description'])"/>
                        <xsl:variable name="summary"
                            select="normalize-space(//column[@name = 'brief_summary'])"/>
                        <xsl:if test="string-length($description) &gt; 0">
                            <description descriptionType="Abstract">
                                <xsl:value-of select="$description"/>
                            </description>
                        </xsl:if>
                        <xsl:if test="string-length($summary) &gt; 0">
                            <description descriptionType="Abstract">
                                <xsl:value-of select="$summary"/>
                            </description>
                        </xsl:if>
                    </descriptions>
                    <xsl:if test="string-length(//column[@name = 'target_sample_size']) &gt; 0">
                        <sizes>
                            <size>
                                <xsl:value-of
                                    select="concat('Target sample size: ', //column[@name = 'target_sample_size'])"
                                />
                            </size>
                        </sizes>
                    </xsl:if>
                    <oaf:accessrights>UNKNOWN</oaf:accessrights>
                    <dr:CobjCategory>clinical trial</dr:CobjCategory>
                    <oaf:dateAccepted>
                        <xsl:value-of select="//column[@name = 'registration_date']"/>
                    </oaf:dateAccepted>
                    <!-- We'll need to do something to patch it, if possible, looking at the jsonProv source name and id -->
                    <oaf:hostedBy id="openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18"
                        name="Unknown Repository"/>
                    <oaf:collectedFrom>
                        <xsl:attribute name="name">
                            <xsl:value-of select="$varOfficialName"/>
                        </xsl:attribute>
                        <xsl:attribute name="id">
                            <xsl:value-of select="$varDataSourceId"/>
                        </xsl:attribute>
                    </oaf:collectedFrom>
                    <oaf:about>
                        <oaf:datainfo>
                            <oaf:inferred>false</oaf:inferred>
                            <oaf:deletedbyinference>false</oaf:deletedbyinference>
                            <oaf:trust>0.9</oaf:trust>
                            <oaf:inferenceprovenance/>
                            <oaf:provenanceaction classid="sysimport:crosswalk:datasetarchive"
                                classname="sysimport:crosswalk:datasetarchive"
                                schemeid="dnet:provenanceActions"
                                schemename="dnet:provenanceActions"/>
                        </oaf:datainfo>
                    </oaf:about>
                </resource>
            </oai:metadata>
            <xsl:copy-of select="//*[local-name() = 'about']"/>
        </oai:record>
    </xsl:template>
</xsl:stylesheet>

]]>
</CODE>
			</SCRIPT>
		</CONFIGURATION>
		<STATUS/>
		<SECURITY_PARAMETERS/>
	</BODY>
</RESOURCE_PROFILE>

