<RESOURCE_PROFILE>
	<HEADER>
		<RESOURCE_IDENTIFIER value="515444fa-b6af-4164-bf52-30e53b916a90_VHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZXMvVHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZVR5cGU="/>
		<RESOURCE_TYPE value="TransformationRuleDSResourceType"/>
		<RESOURCE_KIND value="TransformationRuleDSResources"/>
		<RESOURCE_URI value=""/>
		<DATE_OF_CREATION value="2015-02-27T17:15:30+00:00"/>
	</HEADER>
	<BODY>
		<CONFIGURATION>
			<SOURCE_METADATA_FORMAT name="oaf" layout="store" interpretation="cleaned"/>
			<SINK_METADATA_FORMAT name="oaf_hbase"/>
			<IMPORTED/>
			<SCRIPT>
				<TITLE>xslt_mapping_claimUpdates2hbase</TITLE>
				<CODE>
					<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					                xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
					                xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa"
					                xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:dnet="eu.dnetlib.data.transform.xml.OafToHbaseXsltFunctions"
					                xmlns:date="java.lang.System"
					                xmlns:exslt="http://exslt.org/common"
					                version="1.0"
					                extension-element-prefixes="exslt"
					                exclude-result-prefixes="xsl dc dr dri oaa oaf dnet exslt date">


					<xsl:output omit-xml-declaration="yes" indent="yes"/>

						<xsl:param name="trust" select="string('0.9')"/>
						<xsl:param name="provenance" select="string('UNKNOWN')"/>
						<xsl:param name="namespaceprefix" select="string('unknown_____')"/>

						<xsl:template match="/*">
							<xsl:variable name="about" select="/*[local-name() = 'record']/*[local-name() = 'about']"/>
							<xsl:variable name="dateofcollection" select="//dr:dateOfCollection"/>
							<xsl:variable name="dateoftransformation" select="//dr:dateOfTransformation"/>

							<xsl:variable name="metadata" select="exslt:node-set(//*[local-name()='metadata']/*)"/>
							<xsl:variable name="collectedDatasourceid">
								<xsl:choose>
									<xsl:when test="string-length(//oaf:collectedDatasourceid) &gt; 0">
										<xsl:value-of select="//oaf:collectedDatasourceid"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="UNKNOWN"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>

							<xsl:choose>
								<xsl:when test="count($metadata) = 0">
									<ROWS/>
								</xsl:when>
								<xsl:otherwise>

									<xsl:variable name="objidentifier" select="//record/*[local-name() = 'header']/*[local-name() = 'objIdentifier']"/>

									<xsl:variable name="resultId" select="dnet:oafSimpleId('result', $objidentifier)"/>

									<xsl:variable name="hostedbyid" select="dnet:oafSplitId('datasource', //oaf:hostedBy/@id)"/>
									<xsl:variable name="hostedbyname" select="//oaf:hostedBy/@name"/>

									<xsl:variable name="collectedfromid" select="dnet:oafSplitId('datasource', //oaf:collectedFrom/@id)"/>
									<xsl:variable name="collectedfromname" select="//oaf:collectedFrom/@name"/>

									<xsl:variable name="result"
									              select="dnet:oafResultUpdate($resultId, $provenance, $trust, $metadata, $hostedbyid, $hostedbyname)"/>

									<ROWS>
										<ROW key="{$resultId}" columnFamily="result">
											<QUALIFIER name="{concat('update_', date:nanoTime())}" type="base64">
												<xsl:value-of select="$result"/>
											</QUALIFIER>
										</ROW>
									</ROWS>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:template>

					</xsl:stylesheet>
				</CODE>
			</SCRIPT>
		</CONFIGURATION>
		<STATUS/>
		<SECURITY_PARAMETERS>SECURITY_PARAMETERS</SECURITY_PARAMETERS>
	</BODY>
</RESOURCE_PROFILE>
