package eu.dnetlib.functionality.modular.ui.stats;

import java.util.Date;

public class StatsProcessEntry implements Comparable<StatsProcessEntry> {

	private String procId;
	private long date;

	public StatsProcessEntry() {}

	public StatsProcessEntry(final String procId, final long date) {
		this.procId = procId;
		this.date = date;
	}

	public StatsProcessEntry(final String procId, final Date date) {
		this(procId, dateToLong(date));
	}

	public String getProcId() {
		return procId;
	}

	public void setProcId(final String procId) {
		this.procId = procId;
	}

	public long getDate() {
		return date;
	}

	public void setDate(final long date) {
		this.date = date;
	}

	private static long dateToLong(final Date date) {
		return date == null ? Long.MAX_VALUE : date.getTime();
	}

	@Override
	public int compareTo(final StatsProcessEntry o) {
		return Long.compare(getDate(), o.getDate());
	}

}
