package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import static java.lang.String.format;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.response.UpdateResponse;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.functionality.index.solr.feed.InputDocumentFactory;
import eu.dnetlib.miscutils.datetime.HumanTime;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;

public class FinalizeIndexJobNode extends AsyncJobNode {

	private static final Log log = LogFactory.getLog(FinalizeIndexJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final String version = getEnvParam(token, "index.feed.timestamp");
		final String solrBaseURL = getEnvParam(token, "index.solr.url");
		final String collection = getEnvParam(token, "index.solr.collection");

		final CloudSolrServer solrServer = new CloudSolrServer(solrBaseURL);
		solrServer.setDefaultCollection(collection);

		final String query = "__dsversion:{* TO " + InputDocumentFactory.getParsedDateField(version) + "}";

		log.info("delete by query: " + query);
		UpdateResponse rsp = solrServer.deleteByQuery(query);
		log.info("delete completed, time: " + HumanTime.exactly(rsp.getElapsedTime()));

		log.info("index commit ...");
		rsp = solrServer.commit();
		log.info("index commit completed in: " + HumanTime.exactly(rsp.getElapsedTime()));

		solrServer.shutdown();

		return Arc.DEFAULT_ARC;
	}

	private String getEnvParam(final NodeToken token, final String name) throws MSROException {
		final String value = token.getEnv().getAttribute(name);

		if (StringUtils.isBlank(value))
			throw new MSROException(format("unable to finalize index feeding, cannot find property '%s' in the workflow env.", name));

		return value;
	}

}
