/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.functionality.index.solr.feed.InputDocumentFactory;
import eu.dnetlib.miscutils.datetime.HumanTime;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.response.UpdateResponse;

public class FinalizeIndexJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(FinalizeIndexJobNode.class);

    protected String execute(NodeToken token) throws Exception {
        String version = this.getEnvParam(token, "index.feed.timestamp");
        String solrBaseURL = this.getEnvParam(token, "index.solr.url");
        String collection = this.getEnvParam(token, "index.solr.collection");
        CloudSolrServer solrServer = new CloudSolrServer(solrBaseURL);
        solrServer.setDefaultCollection(collection);
        String query = "__dsversion:{* TO " + InputDocumentFactory.getParsedDateField((String)version) + "}";
        log.info((Object)("delete by query: " + query));
        UpdateResponse rsp = solrServer.deleteByQuery(query);
        log.info((Object)("delete completed, time: " + HumanTime.exactly((long)rsp.getElapsedTime())));
        log.info((Object)"index commit ...");
        rsp = solrServer.commit();
        log.info((Object)("index commit completed in: " + HumanTime.exactly((long)rsp.getElapsedTime())));
        solrServer.shutdown();
        return Arc.DEFAULT_ARC;
    }

    private String getEnvParam(NodeToken token, String name) throws MSROException {
        String value = token.getEnv().getAttribute(name);
        if (StringUtils.isBlank((String)value)) {
            throw new MSROException(String.format("unable to finalize index feeding, cannot find property '%s' in the workflow env.", name));
        }
        return value;
    }
}

