package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class PrepareMDStoreImportJobNode extends SimpleJobNode {

	private String hdfsPathParam;
	
	private String hdfsPath;
	
	private String xsltParam;
	
	private String xslt;
	
	@Override
	protected String execute(NodeToken token) throws Exception {
	
		token.getEnv().setAttribute(getHdfsPathParam(), getHdfsPath());
		token.getEnv().setAttribute(getXsltParam(), readXslt(getXslt()));
		
		return Arc.DEFAULT_ARC;
	}

	private String readXslt(String s) throws IOException {
		ClassPathResource resource = new ClassPathResource(s);
		InputStream inputStream = resource.getInputStream();
		return IOUtils.toString(inputStream);
	}

	public String getHdfsPathParam() {
		return hdfsPathParam;
	}

	public void setHdfsPathParam(String hdfsPathParam) {
		this.hdfsPathParam = hdfsPathParam;
	}

	public String getHdfsPath() {
		return hdfsPath;
	}

	public void setHdfsPath(String hdfsPath) {
		this.hdfsPath = hdfsPath;
	}

	public String getXsltParam() {
		return xsltParam;
	}

	public void setXsltParam(String xsltParam) {
		this.xsltParam = xsltParam;
	}

	public String getXslt() {
		return xslt;
	}

	public void setXslt(String xslt) {
		this.xslt = xslt;
	}

}
