 <NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchOriginals"/>		
	</ARCS>
</NODE>

<NODE name="fetchOriginals" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="user"></PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">OAF</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">orig_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="STOREOBJECT"/>
	</ARCS>
</NODE>

<NODE name="STOREOBJECT" type="DownloadIntoObjectStore">
	<DESCRIPTION>Store files into objectStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="idXpath" managedBy="user">//*[local-name()='objIdentifier']</PARAM>		
		<PARAM required="true" type="string" name="objectStoreId" managedBy="system" category="OBJECTSTORE_ID">$params.("objs_id")$</PARAM>		
		<PARAM required="true" type="string" name="eprParam" managedBy="system">orig_epr</PARAM>
		<PARAM required="false" type="string" name="objectIsInsideEpr" managedBy="system">true</PARAM>
		<PARAM required="true" type="string" name="contentDescription" managedBy="system">$params.("objectStoreContentDescription")$</PARAM>
		
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
