package eu.dnetlib.msro.openaireplus.workflows.nodes.dataFlowMonitoring;

import java.io.IOException;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.monitoring.core.sensors.SensorFactory;
import eu.dnetlib.monitoring.core.sensors.collection.SensorWrapper;
import eu.dnetlib.monitoring.core.sensors.collection.index.solr.SolrSensor;
import eu.dnetlib.monitoring.core.sensors.collection.kv.redis.RedisSensor;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class TriggerPrepublicMonitoringScenarioJobNode extends SimpleJobNode {

	private final Log log = LogFactory.getLog(TriggerPrepublicMonitoringScenarioJobNode.class);

	private enum SolrCollections {
		TMF, DMF
	};

	private final static String SOLR_COLLECTION_POSTFIX = "-index-openaire";
	private String solrXquery;

	@Resource
	private UniqueServiceLocator serviceLocator;

	private SolrSensor solrSensor;
	private RedisSensor redisSensor;
	private SensorWrapper wrapper;

	@Override
	protected String execute(final NodeToken token) throws IOException, InstantiationException, IllegalAccessException, InterruptedException, ISLookUpException {
		log.info("Execution of TriggerPrepublicMonitoringScenarioJobNode");

		/* Configuring SOLR sensor */
		String actualCollection = evaluateCurrentSolrCollection();
		log.info("At this round, the Pre-public monitoring scenario will check against " + actualCollection + "SOLR collection");
		solrSensor = (SolrSensor) SensorFactory.createSensorWithConfiguration(SolrSensor.class, "solr");
		solrSensor.getConfiguration().setParam("collection", actualCollection);

		/* Configuring Redis sensor */
		redisSensor = (RedisSensor) SensorFactory.createSensorWithConfiguration(RedisSensor.class, "redis");

		/* Wrapping the two sensors together */
		wrapper = (SensorWrapper) SensorFactory.createSensor(SensorWrapper.class);
		wrapper.registerSensor(solrSensor);
		wrapper.registerSensor(redisSensor);

		log.info("Measuring prepublic scenario");
		wrapper.measure();
		log.info("DONE!");
		return Arc.DEFAULT_ARC;
	}

	private String evaluateCurrentSolrCollection() throws ISLookUpException {
		List<String> list = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(solrXquery);
		if (list.size() != 1) {
			log.warn("Please check the query: \n" + solrXquery + "\n returns " + list.size() + " elements");
		}
		if (SolrCollections.TMF.equals(list.get(0))) {
			return SolrCollections.DMF + SOLR_COLLECTION_POSTFIX;
		} else {
			return SolrCollections.TMF + SOLR_COLLECTION_POSTFIX;
		}
	}

	public String getSolrXquery() {
		return solrXquery;
	}

	public void setSolrXquery(final String solrXquery) {
		this.solrXquery = solrXquery;
	}

}
